/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.user.client.person.PersonClientFactory;
import com.covisint.platform.user.client.person.PersonClientImpl;
import com.covisint.platform.user.core.person.Person;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class PersonSDK
extends PersonClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public PersonSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public PersonSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public PersonClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public PersonClient newClient() {
        return new ClientImpl((PersonClientImpl)super.create());
    }

    private static final class ClientImpl
    implements PersonClient {
        private final PersonClientImpl delegate;

        private ClientImpl(@Nonnull PersonClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<Person, ServiceException> get(@Nonnull @NotEmpty String personId) {
            return this.delegate.get(personId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Person, ServiceException> add(@Nonnull Person person) {
            return this.delegate.add((Resource)person, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Person, ServiceException> update(@Nonnull Person person) {
            return this.delegate.persist((Resource)person, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<Person>, ServiceException> search(List<String> ids, String authenicationDomain, String username, String parentOrganizationId, @Nonnull Page page) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            if (ids != null && !ids.isEmpty()) {
                searchCriteria.putAll((Object)"id", Iterables.filter(ids, (Predicate)Predicates.notNull()));
            }
            if (StringSupport.trimOrNull((String)username) != null) {
                searchCriteria.put((Object)"username", (Object)username);
                if (StringSupport.trimOrNull((String)authenicationDomain) != null) {
                    searchCriteria.put((Object)"authnDomain", (Object)authenicationDomain);
                }
            }
            if (StringSupport.trimOrNull((String)parentOrganizationId) != null) {
                searchCriteria.put((Object)"organization.id", (Object)parentOrganizationId);
            }
            return this.delegate.search((Multimap)searchCriteria, SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> activate(@Nonnull @NotEmpty String personId) {
            return this.delegate.activate(personId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> suspend(@Nonnull @NotEmpty String personId) {
            return this.delegate.suspend(personId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> unsuspend(@Nonnull @NotEmpty String personId) {
            return this.delegate.unsuspend(personId, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface PersonClient {
        @Nonnull
        public CheckedFuture<Person, ServiceException> get(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<Person, ServiceException> add(@Nonnull Person var1);

        @Nonnull
        public CheckedFuture<Person, ServiceException> update(@Nonnull Person var1);

        @Nonnull
        public CheckedFuture<List<Person>, ServiceException> search(List<String> var1, String var2, String var3, String var4, @Nonnull Page var5);

        public CheckedFuture<Void, ServiceException> activate(@Nonnull @NotEmpty String var1);

        public CheckedFuture<Void, ServiceException> suspend(@Nonnull @NotEmpty String var1);

        public CheckedFuture<Void, ServiceException> unsuspend(@Nonnull @NotEmpty String var1);
    }
}

