/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.util;

import com.covisint.core.support.constraint.Nonnull;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FormUrlEncodedParser {
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    private FormUrlEncodedParser() {
    }

    @Nonnull
    public static Map<String, Object> parse(@Nonnull InputStream input) throws IOException {
        return FormUrlEncodedParser.parse(new InputStreamReader(input, DEFAULT_CHARSET), DEFAULT_CHARSET);
    }

    @Nonnull
    public static Map<String, Object> parse(@Nonnull InputStream input, @Nonnull Charset charset) throws IOException {
        return FormUrlEncodedParser.parse(new InputStreamReader(input, charset), charset);
    }

    @Nonnull
    public static Map<String, Object> parse(@Nonnull Reader reader) throws IOException {
        return FormUrlEncodedParser.parse(reader, DEFAULT_CHARSET);
    }

    @Nonnull
    public static Map<String, Object> parse(@Nonnull Reader reader, @Nonnull Charset charset) throws IOException {
        String body = CharStreams.toString((Readable)reader);
        Iterable pairs = Splitter.on((char)'&').trimResults().split((CharSequence)body);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.put(URLDecoder.decode(pair, charset.name()), null);
                continue;
            }
            String name = URLDecoder.decode(pair.substring(0, idx), charset.name());
            String value = URLDecoder.decode(pair.substring(idx + 1), charset.name());
            result.put(name, value);
        }
        return result;
    }
}

