/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy;

import com.covisint.core.http.service.core.InvocationContext;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.http.service.server.controller.InvalidRequestException;
import com.covisint.core.http.service.server.dao.ResourceDao;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.legacy.InternationalString;
import com.covisint.platform.legacy.SequenceSupplier;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public abstract class BaseResourceJdbcDao<T extends Resource>
extends JdbcDaoSupport
implements ResourceDao<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseResourceJdbcDao.class);
    private SequenceSupplier sequenceSupplier;

    @Nonnull
    @NotEmpty
    protected abstract String getResourceCountSql();

    @Nonnull
    @NotEmpty
    protected abstract String getResourceExistsSql();

    @Nonnull
    @NonnullElements
    protected Map<String, String> getFilterColumnMapping() {
        return Collections.emptyMap();
    }

    @Nonnull
    @NonnullElements
    protected Map<String, String> getSortColumnMapping() {
        return Collections.emptyMap();
    }

    protected String buildFilterClause(Multimap<String, String> queryCriteria, MapSqlParameterSource args) {
        StringBuilder clause = new StringBuilder();
        if (queryCriteria != null) {
            boolean sectionStarted = false;
            for (String key : queryCriteria.keySet()) {
                String mappedColumn = this.getFilterColumnMapping().get(key);
                if (mappedColumn == null) {
                    throw new InvalidRequestException("framework:request:param:invalid", "The following parameter should not be part of the request: " + key);
                }
                if (!sectionStarted) {
                    clause.append(" WHERE ");
                    sectionStarted = true;
                } else {
                    clause.append(" AND ");
                }
                clause.append("UPPER(" + mappedColumn + ")");
                Collection values = Collections2.transform((Collection)queryCriteria.get((Object)key), new UpperCaseFunction());
                if (values.size() == 1) {
                    clause.append(" = :" + key.toUpperCase());
                    args.addValue(key.toUpperCase(), values.iterator().next());
                    continue;
                }
                clause.append(" IN (:" + key.toUpperCase() + ")");
                args.addValue(key.toUpperCase(), (Object)values);
            }
        }
        return clause.toString();
    }

    protected String buildSortClause(List<SortCriteria.SortField> sortFields) {
        StringBuilder clause = new StringBuilder();
        if (sortFields != null) {
            boolean sectionStarted = false;
            for (SortCriteria.SortField sortField : sortFields) {
                if (!sectionStarted) {
                    clause.append(" ORDER BY ");
                    sectionStarted = true;
                } else {
                    clause.append(", ");
                }
                String mappedColumn = this.getSortColumnMapping().get(sortField.getFieldName());
                if (mappedColumn == null) {
                    throw new IllegalStateException("Unsupported sort parameter " + sortField.getFieldName());
                }
                clause.append(mappedColumn).append(" ");
                if (sortField.getSortOrder() == SortCriteria.Order.ASCENDING) {
                    clause.append("ASC");
                    continue;
                }
                clause.append("DESC");
            }
        }
        return clause.toString();
    }

    protected String paginate(String query, Page page) {
        if (page == null || page == Page.ALL) {
            return query;
        }
        long startIdx = (page.getOffset() - 1) * page.getSize() + 1;
        long endIdx = startIdx + (long)page.getSize();
        String pagedSql = String.format("SELECT * FROM ( SELECT ROWNUM RNUM, Q.* from (%s) Q WHERE ROWNUM < %d) WHERE RNUM >= %d", query, endIdx, startIdx);
        LOG.debug("Paginated SQL: {}", (Object)pagedSql);
        return pagedSql;
    }

    @Nonnull
    protected Long getNextSequenceValue() {
        return (Long)this.sequenceSupplier.get();
    }

    protected List<InternationalString> getInternationalStrings(String sql, Collection<String> serviceIds) {
        return BaseResourceJdbcDao.getInternationalStrings(this.getJdbcTemplate(), sql, serviceIds);
    }

    public void setSequenceSupplier(@Nonnull SequenceSupplier newSequenceSupplier) {
        this.sequenceSupplier = newSequenceSupplier;
    }

    public static List<InternationalString> getInternationalStrings(JdbcTemplate jdbcTemplate, String sql, Collection<String> serviceIds) {
        if (serviceIds == null || serviceIds.isEmpty() || StringSupport.trimOrNull((String)sql) == null) {
            return new ArrayList<InternationalString>();
        }
        LOG.debug("Retrieving i18n strings for service ids {} using SQL {}", serviceIds, (Object)sql);
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("ids", serviceIds).addValue("realm", (Object)InvocationContext.getRealmId());
        return new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).query(sql, (SqlParameterSource)args, (RowMapper)new RowMapper<InternationalString>(){

            public InternationalString mapRow(ResultSet rs, int rowNum) throws SQLException {
                String serviceId = rs.getString("ID");
                String lang = rs.getString("LANG");
                String value = rs.getString("VALUE");
                return new InternationalString(serviceId, lang, value);
            }
        });
    }

    public long count() {
        LOG.debug("Counting resources.");
        long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)this.getJdbcTemplate()).queryForObject(this.getResourceCountSql(), (SqlParameterSource)new MapSqlParameterSource().addValue("realm", (Object)InvocationContext.getRealmId()), Long.class);
        LOG.debug("Total count of resources: {}", (Object)count);
        return count;
    }

    public boolean exists(@Nonnull @NotEmpty String id) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("id", (Object)id).addValue("realm", (Object)InvocationContext.getRealmId());
        LOG.debug("Checking if resource exists for id {}", (Object)id);
        boolean exists = (Long)new NamedParameterJdbcTemplate((JdbcOperations)this.getJdbcTemplate()).queryForObject(this.getResourceExistsSql(), (SqlParameterSource)args, Long.class) > 0L;
        LOG.debug("Resource with id {} exists? {}", (Object)id, (Object)exists);
        return exists;
    }

    public class UpperCaseFunction<F, X>
    implements Function<F, X> {
        public Object apply(Object input) {
            if (input == null) {
                return null;
            }
            return input.toString().toUpperCase();
        }
    }
}

