/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy.cleartrust;

import com.covisint.core.http.service.core.InvocationContext;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.legacy.RealmLookupService;
import com.covisint.platform.legacy.cleartrust.ClearTrustFacade;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleartrustFacadeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CleartrustFacadeFactory.class);
    private final Map<String, ClearTrustFacade> realmCTFacades = new HashMap<String, ClearTrustFacade>();
    private final Map<String, ClearTrustFacade> cleartrustFacadeIdentifier;
    private final RealmLookupService realmService;
    private final ClearTrustFacade defaultCleartrustFacade;

    public CleartrustFacadeFactory(@Nonnull RealmLookupService service, @Nonnull @NotEmpty Map<String, ClearTrustFacade> newCTFacades, @Nonnull ClearTrustFacade defaultFacade) {
        if (newCTFacades.isEmpty()) {
            throw new IllegalArgumentException("No cleartrust facade provided.");
        }
        this.realmService = service;
        this.defaultCleartrustFacade = defaultFacade;
        this.cleartrustFacadeIdentifier = new HashMap<String, ClearTrustFacade>();
        for (Map.Entry<String, ClearTrustFacade> ct : newCTFacades.entrySet()) {
            this.cleartrustFacadeIdentifier.put(ct.getKey().toLowerCase(), ct.getValue());
        }
    }

    public ClearTrustFacade determineCleartrustFacade() {
        String realmId = InvocationContext.getRealmId();
        if (StringSupport.trimOrNull((String)realmId) == null) {
            throw new IllegalStateException("No realm id present on the thread!  Check presence of x-realm header.");
        }
        if (this.realmCTFacades.containsKey(realmId)) {
            return this.realmCTFacades.get(realmId);
        }
        LOG.debug("Getting datasource name for realm {}", (Object)realmId);
        String datasourceName = "default";
        try {
            datasourceName = this.realmService.determineDatasourceName();
        }
        catch (IllegalArgumentException e) {
            LOG.debug("No datasource defined for realm {}. ", (Object)realmId);
        }
        ClearTrustFacade ctFacade = this.cleartrustFacadeIdentifier.get(datasourceName);
        if (ctFacade == null) {
            LOG.debug("No cleartrust facade found for datasourceName {}.  Returning default ct facade.", (Object)datasourceName);
            ctFacade = this.defaultCleartrustFacade;
        }
        this.realmCTFacades.put(realmId, ctFacade);
        return ctFacade;
    }
}

