/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core;

import com.covisint.core.http.service.core.Resource;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.core.support.constraint.Sortable;
import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;

@MappedSuperclass
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class AbstractResource<T extends Resource>
implements Resource {
    private static final long serialVersionUID = -9220615487126078224L;
    @Id
    @Searchable
    @Column(name="ID", nullable=false, length=64, updatable=false, unique=true)
    private String id;
    @Version
    @Column(name="VERSION", nullable=false)
    private Long version;
    @Column(name="CREATOR", nullable=false, length=64)
    private String creator;
    @Sortable
    @Column(name="CREATION_INSTANT", nullable=false, scale=10)
    private long creation;
    @Column(name="CREATOR_APPLICATION_ID", nullable=false, length=64)
    private String creatorApplicationId;

    public AbstractResource() {
        this.setCreationInstant(System.currentTimeMillis());
    }

    @Override
    @Nullable
    public final String getId() {
        return this.id;
    }

    public final T setId(@Nonnull @NotEmpty String newId) {
        this.id = newId;
        return (T)this;
    }

    @Override
    @Nullable
    public final Long getVersion() {
        return this.version;
    }

    public final T setVersion(@Nullable Long newVersion) {
        this.version = newVersion;
        return (T)this;
    }

    @Override
    @Nullable
    public final String getCreator() {
        return this.creator;
    }

    public final T setCreator(@Nonnull @NotEmpty String newCreator) {
        this.creator = newCreator;
        return (T)this;
    }

    @Override
    public final long getCreationInstant() {
        return this.creation;
    }

    public final T setCreationInstant(long instant) {
        this.creation = instant;
        return (T)this;
    }

    @Override
    @Nullable
    public final String getCreatorApplicationId() {
        return this.creatorApplicationId;
    }

    public final T setCreatorApplicationId(@Nonnull @NotEmpty String creatorId) {
        this.creatorApplicationId = creatorId;
        return (T)this;
    }

    protected final int getResourceIdentityHashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getVersion()});
    }

    protected final boolean isResourceIdentityEqual(Class<T> resourceType, Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!resourceType.isInstance(obj)) {
            return false;
        }
        Resource other = (Resource)obj;
        return this.getId().equals(other.getId()) && this.getVersion().equals(other.getVersion());
    }

    protected Objects.ToStringHelper populateToStringHelper(Objects.ToStringHelper helper) {
        return helper.add("id", (Object)this.id).add("version", (Object)this.version).add("creator", (Object)this.creator).add("creation", this.creation).add("creatorApplicationId", (Object)this.creatorApplicationId);
    }
}

