/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.NullableElements;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class SortCriteria {
    public static final String SORT_BY_PARAM = "sortBy";
    public static final SortCriteria NONE = SortCriteria.builder().build();
    private ImmutableList<SortField> fields;

    private SortCriteria() {
    }

    @Nonnull
    @NullableElements
    public List<SortField> getSortFields() {
        return this.fields;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static enum Order {
        ASCENDING,
        DESCENDING;

    }

    public static final class SortField {
        private final String fieldName;
        private final Order sortOrder;

        public SortField(@Nonnull @NotEmpty String name, @Nonnull Order order) {
            this.fieldName = name;
            this.sortOrder = order;
        }

        @Nonnull
        @NotEmpty
        public String getFieldName() {
            return this.fieldName;
        }

        @Nonnull
        public Order getSortOrder() {
            return this.sortOrder;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("field", (Object)this.fieldName).add("order", (Object)this.sortOrder).toString();
        }
    }

    public static final class Builder {
        private final ImmutableList.Builder<SortField> fields = new ImmutableList.Builder();

        @Nonnull
        public Builder parseSortField(@Nonnull @NotEmpty String sortField) {
            String parsedName = sortField;
            Order sortOrder = null;
            switch (sortField.charAt(0)) {
                case '+': {
                    sortOrder = Order.ASCENDING;
                    parsedName = sortField.substring(1);
                    break;
                }
                case '-': {
                    sortOrder = Order.DESCENDING;
                    parsedName = sortField.substring(1);
                    break;
                }
                default: {
                    sortOrder = Order.ASCENDING;
                    parsedName = sortField;
                }
            }
            this.fields.add((Object)new SortField(parsedName, sortOrder));
            return this;
        }

        @Nonnull
        public SortCriteria build() {
            SortCriteria criteria = new SortCriteria();
            criteria.fields = this.fields.build();
            return criteria;
        }
    }
}

