/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core.io.jsonp;

import com.covisint.core.http.service.core.AbstractResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceWriter<T extends AbstractResource>
implements EntityWriter {
    public static final String PRETTY_PRINT_MT_ATTRIB = "pretty";
    public static final String INVALID_MEDIA_TYPE = "The server is unable to produce content of type";
    private final Logger log = LoggerFactory.getLogger(AbstractResourceWriter.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final MediaType write(@Nonnull MediaType mediaType, @Nonnull Object source, @Nonnull OutputStream output) {
        JsonObject json;
        this.log.debug("Preparing to write an object of type {}, into a JSON structure", (Object)source.getClass().getName());
        if (!Collection.class.isInstance(source)) {
            json = this.writeResource(mediaType, (AbstractResource)source).build();
        } else {
            this.log.debug("Create JSON array for collection of resources");
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            boolean writable = false;
            for (Object resource : (Collection)source) {
                if (resource == null) {
                    this.log.debug("Encountered null element in collection, skipping it");
                    continue;
                }
                if (!writable && !(writable = this.getResourceType().isAssignableFrom(resource.getClass()))) {
                    throw new EntityWriterException(INVALID_MEDIA_TYPE);
                }
                jsonArrayBuilder.add(this.writeResource(mediaType, (AbstractResource)resource));
            }
            json = jsonArrayBuilder.build();
        }
        this.log.debug("A JSON structure of type {} was created for an object of type {}", (Object)json.getValueType().toString(), (Object)source.getClass().getName());
        JsonWriterFactory factory = this.createWriterFactory(mediaType);
        try (JsonWriter writer = factory.createWriter(output, Charsets.UTF_8);){
            this.log.debug("Writing JSON to output stream");
            writer.write((JsonStructure)json);
            MediaType mediaType2 = mediaType;
            return mediaType2;
        }
        catch (IllegalStateException | JsonException e) {
            this.log.debug("Unable to write JSON to output stream", e);
            throw new EntityWriterException("Unable to write JSON");
        }
    }

    protected JsonObjectBuilder writeResource(MediaType mediaType, T resource) {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        JsonpSupport.addPropertyIfNonnullValue(jsonBuilder, "id", ((AbstractResource)resource).getId());
        if (((AbstractResource)resource).getVersion() != null) {
            jsonBuilder.add("version", ((AbstractResource)resource).getVersion().longValue());
        }
        JsonpSupport.addPropertyIfNonnullValue(jsonBuilder, "creator", ((AbstractResource)resource).getCreator());
        JsonpSupport.addPropertyIfNonnullValue(jsonBuilder, "creatorAppId", ((AbstractResource)resource).getCreatorApplicationId());
        jsonBuilder.add("creation", ((AbstractResource)resource).getCreationInstant());
        return jsonBuilder;
    }

    protected final void writeResourceReference(@Nonnull @NotEmpty String refName, @Nullable ResourceReference reference, @Nonnull JsonObjectBuilder parentJson) {
        if (reference == null) {
            return;
        }
        JsonObjectBuilder json = Json.createObjectBuilder();
        JsonpSupport.addPropertyIfNonnullValue(json, "id", reference.getId());
        JsonpSupport.addPropertyIfNonnullValue(json, "type", reference.getType());
        JsonpSupport.addPropertyIfNonnullValue(json, "realm", reference.getRealm());
        parentJson.add(refName, json);
    }

    @Nonnull
    private JsonWriterFactory createWriterFactory(@Nonnull MediaType mediaType) {
        this.log.debug("Creating JSON writer factory");
        HashMap<String, Boolean> writerConfig = new HashMap<String, Boolean>();
        boolean prettyPrint = this.isPrettyPrintEnabled(mediaType);
        this.log.debug("Pretty printing enabled? {}", (Object)prettyPrint);
        writerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", prettyPrint);
        return Json.createWriterFactory(writerConfig);
    }

    private boolean isPrettyPrintEnabled(@Nonnull MediaType mediaType) {
        ImmutableList prettyPrintParams = mediaType.parameters().get((Object)PRETTY_PRINT_MT_ATTRIB);
        if (prettyPrintParams == null || prettyPrintParams.isEmpty()) {
            return false;
        }
        return Boolean.valueOf((String)prettyPrintParams.get(0));
    }
}

