/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.granttype;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.oauth.core.GrantTypeQualifier;
import com.covisint.platform.oauth.core.domain.AbstractGrantType;
import com.covisint.platform.oauth.core.granttype.GrantTypeBuilder;
import com.covisint.platform.oauth.core.granttype.GrantTypeResolver;
import com.covisint.platform.oauth.core.util.GrantTypeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantTypeResolverImpl
implements GrantTypeResolver {
    private final Logger log = LoggerFactory.getLogger(GrantTypeResolverImpl.class);
    private List<GrantTypeBuilder> grantTypeBuilders;
    private Map<String, Class<? extends AbstractGrantType>> typenameMap;

    public GrantTypeResolverImpl(List<GrantTypeBuilder> builders) {
        this.grantTypeBuilders = builders;
    }

    @Nonnull
    private Map<String, Class<? extends AbstractGrantType>> getGrantTypeMap() {
        if (this.typenameMap == null) {
            this.typenameMap = new HashMap<String, Class<? extends AbstractGrantType>>();
            for (GrantTypeBuilder builder : this.grantTypeBuilders) {
                GrantTypeQualifier gtype = builder.getClass().getAnnotation(GrantTypeQualifier.class);
                if (gtype == null) {
                    this.log.debug("No grant type annotation found for builder {}", builder.getClass());
                    continue;
                }
                this.log.debug("Add grant type {} into map with class {}", (Object)gtype.value(), builder.getSupportedClassType());
                this.typenameMap.put(gtype.value(), builder.getSupportedClassType());
            }
        }
        return this.typenameMap;
    }

    @Override
    @Nullable
    public Class<? extends AbstractGrantType> resolve(@Nonnull Map<String, Object> userInfo) {
        String grantType = GrantTypeUtils.getGrantType(userInfo);
        if (grantType == null) {
            this.log.warn("No grant type information found.");
            return null;
        }
        this.log.debug("Resolving GrantTypeResource class type base on grant type: {}.", (Object)grantType);
        Class<? extends AbstractGrantType> clazz = this.getGrantTypeMap().get(grantType);
        if (clazz == null) {
            this.log.warn("No GrantTypeResource class type that supports grant type: {}", (Object)grantType);
            return null;
        }
        if (!AbstractGrantType.class.isAssignableFrom(clazz)) {
            this.log.warn("Class derived from resolver {} does not extend GrantTypeResource class type");
            return null;
        }
        this.log.debug("Resolver found GrantType class {} that supports grant type: {}", clazz, (Object)grantType);
        return clazz;
    }
}

