/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.legacy.address.Address;
import com.covisint.platform.legacy.phone.Phones;
import com.covisint.platform.user.core.person.CurrencyInfo;
import com.covisint.platform.user.core.person.LanguageInfo;
import com.covisint.platform.user.core.person.Status;
import com.covisint.platform.user.core.person.TimeZoneInfo;
import com.google.common.base.Objects;

public class Person
extends AbstractRealmScopedResource<Person> {
    private static final long serialVersionUID = -3558551036273649673L;
    private Integer statusId;
    private String namePrefix;
    private String givenName;
    private String middleName;
    private String surname;
    private String nameSuffix;
    private Address mainAddress = new Address();
    private CurrencyInfo preferredCurrency;
    private LanguageInfo preferredLanguage;
    private TimeZoneInfo preferredTimezone;
    private Phones phones = new Phones();
    private String email;
    private String jobTitle;
    @Searchable
    private ResourceReference organization;
    @Searchable
    private String authnDomain;
    @Searchable
    private String username;
    private long userId;

    @Nullable
    public Status getStatus() {
        if (this.statusId == null) {
            return null;
        }
        return Status.fromId(this.statusId);
    }

    public Person setStatus(@Nonnull Status newStatus) {
        this.statusId = newStatus.getId();
        return this;
    }

    @Nullable
    public String getNamePrefix() {
        return this.namePrefix;
    }

    public Person setNamePrefix(@Nullable String prefix) {
        this.namePrefix = StringSupport.trimOrNull((String)prefix);
        return this;
    }

    @Nullable
    public String getGivenName() {
        return this.givenName;
    }

    public Person setGivenName(@Nonnull @NotEmpty String name) {
        this.givenName = name;
        return this;
    }

    @Nullable
    public String getMiddleName() {
        return this.middleName;
    }

    public Person setMiddleName(@Nullable String name) {
        this.middleName = StringSupport.trimOrNull((String)name);
        return this;
    }

    @Nullable
    public String getSurname() {
        return this.surname;
    }

    public Person setSurname(@Nonnull @NotEmpty String name) {
        this.surname = name;
        return this;
    }

    @Nullable
    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public Person setNameSuffix(@Nullable String suffix) {
        this.nameSuffix = StringSupport.trimOrNull((String)suffix);
        return this;
    }

    @Nullable
    public Address getMainAddress() {
        return this.mainAddress;
    }

    public Person setMainAddress(@Nonnull Address address) {
        address.setOwner((Resource)this);
        this.mainAddress = address;
        return this;
    }

    @Nullable
    public Phones getPhones() {
        return this.phones;
    }

    public Person setPhones(@Nonnull Phones newPhones) {
        newPhones.setOwner((Resource)this);
        this.phones = newPhones;
        return this;
    }

    @Nullable
    public CurrencyInfo getPreferredCurrency() {
        return this.preferredCurrency;
    }

    public Person setPreferredCurrency(@Nullable String currencyCode) {
        this.preferredCurrency = new CurrencyInfo();
        this.preferredCurrency.setCode(currencyCode);
        return this;
    }

    @Nullable
    public LanguageInfo getPreferredLanguageInfo() {
        return this.preferredLanguage;
    }

    public Person setPreferredLanguageInfo(@Nonnull LanguageInfo language) {
        this.preferredLanguage = language;
        return this;
    }

    @Nullable
    public String getPreferredLanguage() {
        if (this.preferredLanguage == null) {
            return null;
        }
        return this.preferredLanguage.getIsoLocale();
    }

    public Person setPreferredLanguage(@Nonnull @NotEmpty String language) {
        this.preferredLanguage = new LanguageInfo();
        this.preferredLanguage.setIsoLocale(language);
        return this;
    }

    @Nullable
    public TimeZoneInfo getPreferredTimezoneInfo() {
        return this.preferredTimezone;
    }

    public Person setPreferredTimezoneInfo(@Nonnull TimeZoneInfo timezone) {
        this.preferredTimezone = timezone;
        return this;
    }

    @Nullable
    public String getPreferredTimezone() {
        if (this.preferredTimezone == null) {
            return null;
        }
        return this.preferredTimezone.getJavaId();
    }

    public Person setPreferredTimezone(@Nonnull @NotEmpty String timezone) {
        this.preferredTimezone = new TimeZoneInfo();
        this.preferredTimezone.setJavaId(timezone);
        return this;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public Person setEmail(@Nullable String address) {
        this.email = StringSupport.trimOrNull((String)address);
        return this;
    }

    @Nullable
    public ResourceReference getOrganization() {
        return this.organization;
    }

    @Nonnull
    public Person setOrganization(@Nonnull ResourceReference newOrganization) {
        this.organization = newOrganization;
        return this;
    }

    @Nonnull
    public Person setOrganizationId(@Nonnull @NotEmpty String organizationId) {
        this.organization = new ResourceReference(organizationId, "organization");
        return this;
    }

    @Nullable
    public String getJobTitle() {
        return this.jobTitle;
    }

    public Person setJobTitle(@Nullable String title) {
        this.jobTitle = StringSupport.trimOrNull((String)title);
        return this;
    }

    @Nullable
    public String getAuthnDomain() {
        return this.authnDomain;
    }

    public Person setAuthnDomain(@Nonnull String newAuthnDomain) {
        this.authnDomain = newAuthnDomain;
        return this;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public Person setUsername(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public long getUserId() {
        return this.userId;
    }

    public Person setUserId(long newUserId) {
        this.userId = newUserId;
        return this;
    }

    public void postLoad() {
        if (this.phones == null) {
            this.phones = new Phones();
        }
        if (this.mainAddress == null) {
            this.mainAddress = new Address();
        }
        this.phones.init();
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(Person.class, obj);
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper(Person.class)).add("status", (Object)this.statusId).add("namePrefix", (Object)this.namePrefix).add("givenName", (Object)this.givenName).add("middleName", (Object)this.middleName).add("surname", (Object)this.surname).add("nameSuffix", (Object)this.nameSuffix).add("preferredLanguage", (Object)this.getPreferredLanguage()).add("preferredTimezone", (Object)this.getPreferredTimezone()).add("preferredCurrency", (Object)this.preferredCurrency).add("email", (Object)this.email).add("jobTitle", (Object)this.jobTitle).add("address", (Object)this.mainAddress).add("phones", (Object)this.phones).add("organization", (Object)this.organization).toString();
    }
}

