/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.account.password;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.user.core.person.Person;
import com.covisint.platform.user.core.person.account.Account;
import com.google.common.base.Objects;

public class PasswordAccount
extends AbstractRealmScopedResource<PasswordAccount>
implements Account {
    public static final String ACCOUNT_TYPE = "password";
    private static final long serialVersionUID = 8945212822232184402L;
    private String username;
    private String password;
    private ResourceReference passwordPolicy;
    private ResourceReference authnPolicy;
    private long expirationInstant;
    private boolean isLocked;
    private long unlockInstant;
    private Person owner;

    @Override
    @Nonnull
    @NotEmpty
    public String getType() {
        return ACCOUNT_TYPE;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public PasswordAccount setUsername(@Nonnull String newUsername) {
        this.username = newUsername.toUpperCase();
        return this;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public PasswordAccount setPassword(@Nonnull String newPassword) {
        this.password = newPassword;
        return this;
    }

    @Nullable
    public ResourceReference getPasswordPolicy() {
        return this.passwordPolicy;
    }

    @Nonnull
    public PasswordAccount setPasswordPolicy(@Nonnull ResourceReference newPasswordPolicy) {
        this.passwordPolicy = newPasswordPolicy;
        return this;
    }

    @Nonnull
    public final PasswordAccount setPasswordPolicyId(@Nonnull @NotEmpty String id) {
        this.passwordPolicy = new ResourceReference(id, "passwordPolicy");
        return this;
    }

    @Nullable
    public ResourceReference getAuthnPolicy() {
        return this.authnPolicy;
    }

    @Nonnull
    public PasswordAccount setAuthnPolicy(@Nonnull ResourceReference newAuthnPolicy) {
        this.authnPolicy = newAuthnPolicy;
        return this;
    }

    @Nonnull
    public PasswordAccount setAuthnPolicyId(@Nonnull @NotEmpty String id) {
        this.authnPolicy = new ResourceReference(id, "authenticationPolicy");
        return this;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public PasswordAccount setLocked(boolean newLocked) {
        this.isLocked = newLocked;
        return this;
    }

    public long getExpirationInstant() {
        return this.expirationInstant;
    }

    public PasswordAccount setExpirationInstant(long newExpirationInstant) {
        this.expirationInstant = newExpirationInstant;
        return this;
    }

    public long getUnlockInstant() {
        return this.unlockInstant;
    }

    public PasswordAccount setUnlockInstant(long newUnlockInstant) {
        this.unlockInstant = newUnlockInstant;
        return this;
    }

    @Nullable
    public Person getOwner() {
        return this.owner;
    }

    public PasswordAccount setOwner(@Nonnull Person newOwner) {
        this.owner = newOwner;
        return this;
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(PasswordAccount.class, obj);
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper(PasswordAccount.class)).add("passwordPolicy", (Object)this.passwordPolicy).add("authnPolicy", (Object)this.authnPolicy).add("username", (Object)this.getUsername()).add("expiration", this.expirationInstant).add("isLocked", this.isLocked).add("unlockInstant", this.unlockInstant).toString();
    }
}

