/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.io.json;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.user.core.person.Person;
import com.covisint.platform.user.core.person.PersonJsonSupport;
import com.covisint.platform.user.core.person.Status;
import com.covisint.platform.user.core.person.SupportedMediaType;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.net.MediaType;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonReader
extends AbstractRealmScopedResourceReader<Person> {
    private final Logger log = LoggerFactory.getLogger(PersonReader.class);

    private void readStatus(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonString stringProperty = src.getJsonString("status");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            Optional status = Enums.getIfPresent(Status.class, (String)stringProperty.getString().toUpperCase());
            if (status.isPresent()) {
                person.setStatus(Status.valueOf(stringProperty.getString().toUpperCase()));
            } else {
                this.log.warn("Invalid status value {} found...skipping status", (Object)stringProperty);
            }
        }
    }

    private void readTitle(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonString stringProperty = src.getJsonString("title");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setJobTitle(stringProperty.getString());
        }
    }

    private void readGivenName(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonString stringProperty = src.getJsonString("given");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setGivenName(stringProperty.getString());
        }
    }

    private void readSurName(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonString stringProperty = src.getJsonString("surname");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setSurname(stringProperty.getString());
        }
    }

    private void readName(@Nonnull JsonObject json, @Nonnull Person person) {
        JsonObject src = json.getJsonObject("name");
        if (src == null) {
            return;
        }
        JsonString stringProperty = src.getJsonString("prefix");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setNamePrefix(stringProperty.getString());
        }
        this.readGivenName(src, person);
        stringProperty = src.getJsonString("middle");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setMiddleName(stringProperty.getString());
        }
        this.readSurName(src, person);
        stringProperty = src.getJsonString("suffix");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setNameSuffix(stringProperty.getString());
        }
    }

    private void readStreets(@Nonnull Person person, JsonArray src) {
        if (src == null || src.isEmpty()) {
            return;
        }
        int ct = src.size();
        person.getMainAddress().setAddress1(src.getString(0));
        if (ct > 1) {
            person.getMainAddress().setAddress2(src.getString(1));
        }
        if (ct > 2) {
            person.getMainAddress().setAddress3(src.getString(2));
        }
        if (ct > 3) {
            this.log.warn("Maximum allowed street addresses is 3.");
        }
    }

    private void readAddress(@Nonnull Person person, JsonObject src) {
        if (src == null) {
            return;
        }
        this.readStreets(person, src.getJsonArray("streets"));
        JsonString stringProperty = src.getJsonString("city");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.getMainAddress().setCity(stringProperty.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = src.getJsonString("state")))) {
            person.getMainAddress().setState(stringProperty.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = src.getJsonString("postal")))) {
            person.getMainAddress().setPostal(stringProperty.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = src.getJsonString("country")))) {
            try {
                person.getMainAddress().setCountry(stringProperty.getString());
            }
            catch (IllegalArgumentException e) {
                this.log.warn("country code {} is not an ISO 3166 country code..so skipping it.", (Object)stringProperty.getString());
            }
        }
    }

    private void readAddresses(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonArray addressesJson = src.getJsonArray("addresses");
        if (addressesJson == null || addressesJson.isEmpty()) {
            return;
        }
        this.readAddress(person, addressesJson.getJsonObject(0));
    }

    private void readEmail(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonString stringProperty = src.getJsonString("email");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setEmail(stringProperty.getString());
        }
    }

    private void readOrganization(@Nonnull JsonObject src, @Nonnull Person person) {
        ResourceReference organization = PersonReader.readResourceReference((JsonObject)src.getJsonObject("organization"));
        if (organization != null) {
            person.setOrganization(organization);
        }
    }

    private void readPhones(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonArray phones = src.getJsonArray("phones");
        if (phones == null || phones.isEmpty()) {
            return;
        }
        for (int i = 0; i < phones.size(); ++i) {
            JsonObject phone = phones.getJsonObject(i);
            JsonString typeJsonString = phone.getJsonString("type");
            JsonString numberJsonString = phone.getJsonString("number");
            String type = null;
            if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)typeJsonString)) {
                type = typeJsonString.getString().toLowerCase();
            }
            String number = null;
            if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)numberJsonString)) {
                number = numberJsonString.getString();
            }
            person.getPhones().setByType(type, number);
        }
    }

    private void readPreferredTimezone(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonString stringProperty = src.getJsonString("timezone");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setPreferredTimezone(stringProperty.getString());
        } else {
            this.log.warn("Preferred timezone must be specified.");
        }
    }

    private void readPreferredLanguage(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonString stringProperty = src.getJsonString("language");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            person.setPreferredLanguage(stringProperty.getString());
        } else {
            this.log.warn("Preferred language must be specified.");
        }
    }

    private void readPreferredCurrency(@Nonnull JsonObject src, @Nonnull Person person) {
        JsonString stringProperty = src.getJsonString("currency");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            String currencyCode = stringProperty.getString();
            try {
                person.setPreferredCurrency(currencyCode);
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Currency code {} is not an ISO 4217 code", (Object)currencyCode);
            }
        }
    }

    @Nonnull
    protected Person createResource(@Nonnull MediaType mediaType) {
        return new Person();
    }

    protected Person readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        Person person = (Person)super.readResource(mediaType, json);
        this.readStatus(json, person);
        this.readTitle(json, person);
        this.readName(json, person);
        this.readAddresses(json, person);
        this.readEmail(json, person);
        this.readPhones(json, person);
        this.readOrganization(json, person);
        this.readPreferredLanguage(json, person);
        this.readPreferredTimezone(json, person);
        this.readPreferredCurrency(json, person);
        return person;
    }

    @Nonnull
    public Class<Person> getResourceType() {
        return Person.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return PersonJsonSupport.isMediaTypeSame(SupportedMediaType.PERSON_MT, mediaType);
    }
}

