/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.request.io.json;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.user.core.person.PersonJsonSupport;
import com.covisint.platform.user.core.person.SupportedMediaType;
import com.covisint.platform.user.core.person.request.PersonRequest;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;

public class PersonRequestReader
extends AbstractRealmScopedResourceReader<PersonRequest> {
    @Nonnull
    protected final PersonRequest createResource(@Nonnull MediaType mediaType) {
        return new PersonRequest();
    }

    @Nonnull
    protected final PersonRequest readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        JsonString justification;
        PersonRequest personRequest = (PersonRequest)super.readResource(mediaType, json);
        ResourceReference registrant = PersonRequestReader.readResourceReference((JsonObject)json.getJsonObject("registrant"));
        if (registrant != null) {
            personRequest.setRegistrant(registrant);
        }
        personRequest.setPackageId(PersonJsonSupport.readResourceObj(json, "servicePackageRequest", "packageId"));
        String codeString = PersonJsonSupport.readResourceObj(json, "servicePackageRequest", "code");
        if (codeString != null) {
            personRequest.setCode(codeString);
            codeString = PersonJsonSupport.readResourceObj(json, "servicePackageRequest", "codeKind");
            if (codeString != null) {
                personRequest.setCodeKind(codeString);
            }
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(justification = json.getJsonString("justification")))) {
            personRequest.setJustification(justification.getString());
        }
        return personRequest;
    }

    @Nonnull
    public final Class<PersonRequest> getResourceType() {
        return PersonRequest.class;
    }

    @Nonnull
    public final boolean isReadable(@Nonnull MediaType mediaType) {
        return PersonJsonSupport.isMediaTypeSame(SupportedMediaType.PERSON_REQUEST_MT, mediaType);
    }
}

