/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.core.person.request.io.json;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.user.core.person.PersonJsonSupport;
import com.covisint.platform.user.core.person.SupportedMediaType;
import com.covisint.platform.user.core.person.request.PersonRequest;
import com.google.common.net.MediaType;
import javax.json.Json;
import javax.json.JsonObjectBuilder;

public class PersonRequestWriter
extends AbstractRealmScopedResourceWriter<PersonRequest> {
    private void writeServicePackageRequest(@Nonnull JsonObjectBuilder builder, @Nonnull PersonRequest personRequest) {
        JsonObjectBuilder servicePackageRequestJson = Json.createObjectBuilder();
        if (personRequest.getPackageId() != null) {
            servicePackageRequestJson.add("packageId", personRequest.getPackageId());
        }
        if (personRequest.getPackageRealm() != null) {
            servicePackageRequestJson.add("realm", personRequest.getPackageRealm());
        } else if (personRequest.getRealm() != null) {
            servicePackageRequestJson.add("realm", personRequest.getRealm());
        }
        String code = StringSupport.trimOrNull((String)personRequest.getCode());
        if (code != null) {
            servicePackageRequestJson.add("code", code);
            String codeKind = StringSupport.trimOrNull((String)personRequest.getCodeKind());
            if (codeKind != null) {
                servicePackageRequestJson.add("codeKind", codeKind);
            }
        }
        builder.add("servicePackageRequest", servicePackageRequestJson);
    }

    @Nonnull
    protected final JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull PersonRequest personRequest) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)personRequest);
        if (personRequest.getJustification() != null) {
            JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"justification", (String)personRequest.getJustification());
        }
        if (personRequest.getRegistrant() != null) {
            this.writeResourceReference("registrant", personRequest.getRegistrant(), builder);
        }
        this.writeServicePackageRequest(builder, personRequest);
        return builder;
    }

    @Nonnull
    public final Class<PersonRequest> getResourceType() {
        return PersonRequest.class;
    }

    @Nonnull
    public final boolean isWritable(@Nonnull Class clazz, @Nonnull MediaType mediaType) {
        return PersonJsonSupport.isMediaTypeSame(SupportedMediaType.PERSON_REQUEST_MT, mediaType);
    }
}

