/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.support.httpclient;

import com.covisint.core.support.aspect.NonnullElementsValidator;
import com.covisint.core.support.aspect.NonnullValidator;
import com.covisint.core.support.aspect.NotEmptyValidator;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.NotThreadSafe;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.NullableElements;
import com.covisint.core.support.constraint.Unmodifiable;
import com.covisint.core.support.httpclient.AuthorizationTokenInterceptor;
import com.covisint.core.support.httpclient.RequestConnectionCloseInterceptor;
import com.covisint.core.support.httpclient.SpanInterceptor;
import com.covisint.core.support.httpclient.XRealmInterceptor;
import com.covisint.core.support.httpclient.XRequestorApplicationInterceptor;
import com.covisint.core.support.httpclient.XRequestorInterceptor;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@NotThreadSafe
public class HttpClientBuilder {
    private InetAddress sourceAddress;
    private int socketTimeout = 5000;
    private int socketBufferSize = 8192;
    private SSLContext sslContext;
    private int connectionTimeout = 5000;
    private int connectionMax = 100;
    private boolean connectionCloseAfterResponseEnabled = true;
    private String connectionProxyHost;
    private int connectionProxyPort;
    private String connectionProxyUsername;
    private String connectionProxyPassword;
    private boolean followRedirects = true;
    private int maxRedirects = 5;
    private boolean cookiesEnabled = false;
    private CookieStore cookieStore;
    private boolean contentCompressionEnabled = true;
    private Charset contentCharSet = Charsets.UTF_8;
    private String userAgent = "Covisint Apache-HttpClient";
    private List<HttpRequestInterceptor> requestInterceptors = new ArrayList<HttpRequestInterceptor>();
    private List<HttpResponseInterceptor> responseInterceptors = new ArrayList<HttpResponseInterceptor>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;

    public HttpClientBuilder() {
        this.sslContext = this.buildSSLContext();
    }

    @Nullable
    protected final InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    @Nonnull
    public final HttpClientBuilder setSourceAddress(@NotEmpty @Nonnull String address) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        NotEmptyValidator.aspectOf().validateMethodArg1((Object)string, joinPoint);
        NonnullValidator.aspectOf().validateMethodArg1((Object)string, joinPoint);
        try {
            this.sourceAddress = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder setSourceInetAddress(@Nonnull InetAddress address) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        InetAddress inetAddress = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)inetAddress);
        NonnullValidator.aspectOf().validateMethodArg1((Object)inetAddress, joinPoint);
        this.sourceAddress = address;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Nonnull
    public final HttpClientBuilder setSocketTimeout(int timeout) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        int n = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.socketTimeout = timeout;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder setSocketTimeoutByTimeUnit(int time, @Nonnull TimeUnit unit) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        TimeUnit timeUnit = unit;
        int n = time;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)((Object)timeUnit));
        NonnullValidator.aspectOf().validateMethodArg2((Object)timeUnit, joinPoint);
        this.socketTimeout = this.toIntMilliseconds(time, unit);
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nullable
    protected final SSLContext getSslContext() {
        return this.sslContext;
    }

    @Nonnull
    public final HttpClientBuilder setSslContext(SSLContext context) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        SSLContext sSLContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)sSLContext);
        this.sslContext = context;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Nonnull
    public final HttpClientBuilder socketBufferSize(int size) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        int n = size;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.socketBufferSize = size;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Nonnull
    public final HttpClientBuilder setConnectionTimeout(int timeout) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        int n = timeout;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.connectionTimeout = timeout;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder setConnectionTimeoutByTimeUnit(int time, @Nonnull TimeUnit unit) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        TimeUnit timeUnit = unit;
        int n = time;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)((Object)timeUnit));
        NonnullValidator.aspectOf().validateMethodArg2((Object)timeUnit, joinPoint);
        this.connectionTimeout = this.toIntMilliseconds(time, unit);
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final int getMaxConnections() {
        return this.connectionMax;
    }

    @Nonnull
    public final HttpClientBuilder setMaxConnections(int max) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        int n = max;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.connectionMax = max;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final boolean isContentCompressionEnabled() {
        return this.contentCompressionEnabled;
    }

    @Nonnull
    public final HttpClientBuilder setContentCompressionEnabled(boolean enabled) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        boolean bl = enabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        this.contentCompressionEnabled = enabled;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final boolean isConnectionClosedAfterResponse() {
        return this.connectionCloseAfterResponseEnabled;
    }

    @Nonnull
    public final HttpClientBuilder setConnectionClosedAfterResponse(boolean isClosed) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        boolean bl = isClosed;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        this.connectionCloseAfterResponseEnabled = isClosed;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final String getConnectionProxyHost() {
        return this.connectionProxyHost;
    }

    @Nonnull
    public final HttpClientBuilder setConnectionProxyHost(String host) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        String string = host;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        this.connectionProxyHost = host;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final int getConnectionProxyPort() {
        return this.connectionProxyPort;
    }

    @Nonnull
    public final HttpClientBuilder setConnectionProxyPort(int port) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        int n = port;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        this.connectionProxyPort = port;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final String getConnectionProxyUsername() {
        return this.connectionProxyUsername;
    }

    @Nonnull
    public final HttpClientBuilder setConnectionProxyUsername(String username) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        this.connectionProxyUsername = username;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final String getConnectionProxyPassword() {
        return this.connectionProxyPassword;
    }

    @Nonnull
    public final HttpClientBuilder setConnectionProxyPassword(String password) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        String string = password;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string);
        this.connectionProxyPassword = password;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder addSpanInterceptor(@Nonnull @NotEmpty String spanHeaderName, @Nonnull @NotEmpty String traceHeaderName) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        String string = traceHeaderName;
        String string2 = spanHeaderName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string2, (Object)string);
        NotEmptyValidator.aspectOf().validateMethodArg1((Object)string2, joinPoint);
        NotEmptyValidator.aspectOf().validateMethodArg2((Object)string, joinPoint);
        NonnullValidator.aspectOf().validateMethodArg1((Object)string2, joinPoint);
        NonnullValidator.aspectOf().validateMethodArg2((Object)string, joinPoint);
        this.addRequestInterceptor(new SpanInterceptor(traceHeaderName, spanHeaderName));
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder addXRequestorInterceptor() {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        this.addRequestInterceptor(new XRequestorInterceptor());
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder addXRequestorApplicationInterceptor() {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        this.addRequestInterceptor(new XRequestorApplicationInterceptor());
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder addXRealmInterceptor() {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        this.addRequestInterceptor(new XRealmInterceptor());
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder addAuthorizationTokenInterceptor(@Nonnull Supplier<String> tokenSupplier) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        Supplier<String> supplier = tokenSupplier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, supplier);
        NonnullValidator.aspectOf().validateMethodArg1(supplier, joinPoint);
        this.addRequestInterceptor(new AuthorizationTokenInterceptor(tokenSupplier));
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    protected final boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Nonnull
    public final HttpClientBuilder setFollowRedirects(boolean follow) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        boolean bl = follow;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        this.followRedirects = follow;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    public final int getMaxRedirects() {
        return this.maxRedirects;
    }

    public final HttpClientBuilder setMaxRedirects(int max) {
        this.maxRedirects = max;
        return this;
    }

    protected final boolean isCookiesEnabled() {
        return this.cookiesEnabled;
    }

    @Nonnull
    public final HttpClientBuilder setCookiesEnabled(boolean enabled) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        boolean bl = enabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        this.cookiesEnabled = true;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    @NotEmpty
    @NonnullElements
    protected final List<HttpRequestInterceptor> getRequestInterceptors() {
        List<HttpRequestInterceptor> list;
        List<HttpRequestInterceptor> list2;
        List<HttpRequestInterceptor> list3;
        List<HttpRequestInterceptor> list4;
        List<HttpRequestInterceptor> list5;
        List<HttpRequestInterceptor> list6;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        List<HttpRequestInterceptor> list7 = list6 = (list5 = Collections.unmodifiableList(this.requestInterceptors));
        NonnullValidator.aspectOf().validateMethodReturnValue(list6, joinPoint);
        List<HttpRequestInterceptor> list8 = list4 = (list3 = list5);
        NonnullElementsValidator.aspectOf().validateMethodReturnValue(list4, joinPoint);
        List<HttpRequestInterceptor> list9 = list2 = (list = list3);
        NotEmptyValidator.aspectOf().validateMethodReturnValue(list2, joinPoint);
        return list;
    }

    @Nonnull
    public final HttpClientBuilder setRequestInterceptors(@Nullable @NullableElements List<HttpRequestInterceptor> interceptors) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        List<HttpRequestInterceptor> list = interceptors;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, list);
        this.requestInterceptors = interceptors == null ? new ArrayList<HttpRequestInterceptor>() : Lists.newArrayList((Iterable)Iterables.filter(interceptors, (Predicate)Predicates.notNull()));
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder addRequestInterceptor(@Nullable HttpRequestInterceptor interceptor) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        HttpRequestInterceptor httpRequestInterceptor = interceptor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)httpRequestInterceptor);
        if (interceptor != null && !this.requestInterceptors.contains(interceptor)) {
            this.requestInterceptors.add(interceptor);
        }
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    @NotEmpty
    @NonnullElements
    @Unmodifiable
    protected final List<HttpResponseInterceptor> getResponseInterceptors() {
        List<HttpResponseInterceptor> list;
        List<HttpResponseInterceptor> list2;
        List<HttpResponseInterceptor> list3;
        List<HttpResponseInterceptor> list4;
        List<HttpResponseInterceptor> list5;
        List<HttpResponseInterceptor> list6;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        List<HttpResponseInterceptor> list7 = list6 = (list5 = Collections.unmodifiableList(this.responseInterceptors));
        NonnullValidator.aspectOf().validateMethodReturnValue(list6, joinPoint);
        List<HttpResponseInterceptor> list8 = list4 = (list3 = list5);
        NonnullElementsValidator.aspectOf().validateMethodReturnValue(list4, joinPoint);
        List<HttpResponseInterceptor> list9 = list2 = (list = list3);
        NotEmptyValidator.aspectOf().validateMethodReturnValue(list2, joinPoint);
        return list;
    }

    @Nonnull
    public final HttpClientBuilder setResponseInterceptors(@Nullable @NullableElements List<HttpResponseInterceptor> interceptors) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        List<HttpResponseInterceptor> list = interceptors;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, list);
        this.responseInterceptors = interceptors == null ? new ArrayList<HttpResponseInterceptor>() : Lists.newArrayList((Iterable)Iterables.filter(interceptors, (Predicate)Predicates.notNull()));
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    public final HttpClientBuilder addResponseInterceptor(HttpResponseInterceptor interceptor) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        HttpResponseInterceptor httpResponseInterceptor = interceptor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)httpResponseInterceptor);
        if (interceptor != null && !this.responseInterceptors.contains(interceptor)) {
            this.responseInterceptors.add(interceptor);
        }
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nonnull
    @NotEmpty
    protected final String getUserAgent() {
        String string;
        String string2;
        String string3;
        String string4;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        String string5 = string4 = (string3 = this.userAgent);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)string4, joinPoint);
        String string6 = string2 = (string = string3);
        NotEmptyValidator.aspectOf().validateMethodReturnValue((Object)string2, joinPoint);
        return string;
    }

    @Nonnull
    public final HttpClientBuilder setUserAgent(@Nonnull @NotEmpty String agent) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        String string = agent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string);
        NotEmptyValidator.aspectOf().validateMethodArg1((Object)string, joinPoint);
        NonnullValidator.aspectOf().validateMethodArg1((Object)string, joinPoint);
        this.userAgent = agent;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    @Nullable
    protected final CookieStore getCookieStore() {
        return this.cookieStore;
    }

    @Nonnull
    public final HttpClientBuilder withCookieStore(@Nullable CookieStore store) {
        HttpClientBuilder httpClientBuilder;
        HttpClientBuilder httpClientBuilder2;
        CookieStore cookieStore = store;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)cookieStore);
        this.cookieStore = store;
        HttpClientBuilder httpClientBuilder3 = httpClientBuilder2 = (httpClientBuilder = this);
        NonnullValidator.aspectOf().validateMethodReturnValue((Object)httpClientBuilder2, joinPoint);
        return httpClientBuilder;
    }

    public final HttpClient build() {
        org.apache.http.impl.client.HttpClientBuilder clientBuilder = this.createClientBuilder();
        return clientBuilder.build();
    }

    protected org.apache.http.impl.client.HttpClientBuilder createClientBuilder() {
        org.apache.http.impl.client.HttpClientBuilder clientBuilder = org.apache.http.impl.client.HttpClientBuilder.create();
        this.addSocketConfiguration(clientBuilder);
        if (this.sslContext != null) {
            clientBuilder.setSslcontext(this.sslContext);
        }
        this.addConnectionConfiguration(clientBuilder);
        clientBuilder.setMaxConnTotal(this.connectionMax);
        clientBuilder.setMaxConnPerRoute(this.connectionMax);
        this.addRequestConfiguration(clientBuilder);
        clientBuilder.setUserAgent(this.userAgent);
        if (!this.contentCompressionEnabled) {
            clientBuilder.disableContentCompression();
        }
        this.addInterceptors(clientBuilder);
        this.addCookieManagement(clientBuilder);
        return clientBuilder;
    }

    protected void addSocketConfiguration(@Nonnull org.apache.http.impl.client.HttpClientBuilder clientBuilder) {
        org.apache.http.impl.client.HttpClientBuilder httpClientBuilder = clientBuilder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)httpClientBuilder);
        NonnullValidator.aspectOf().validateMethodArg1((Object)httpClientBuilder, joinPoint);
        clientBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.socketTimeout).build());
    }

    protected void addConnectionConfiguration(@Nonnull org.apache.http.impl.client.HttpClientBuilder clientBuilder) {
        org.apache.http.impl.client.HttpClientBuilder httpClientBuilder = clientBuilder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)httpClientBuilder);
        NonnullValidator.aspectOf().validateMethodArg1((Object)httpClientBuilder, joinPoint);
        clientBuilder.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(this.socketBufferSize).setCharset(this.contentCharSet).build());
    }

    protected void addRequestConfiguration(@Nonnull org.apache.http.impl.client.HttpClientBuilder clientBuilder) {
        org.apache.http.impl.client.HttpClientBuilder httpClientBuilder = clientBuilder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)httpClientBuilder);
        NonnullValidator.aspectOf().validateMethodArg1((Object)httpClientBuilder, joinPoint);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectionRequestTimeout(this.connectionTimeout);
        if (this.sourceAddress != null) {
            builder.setLocalAddress(this.sourceAddress);
        }
        builder.setRedirectsEnabled(this.followRedirects).setMaxRedirects(this.maxRedirects);
        if (this.connectionProxyHost != null) {
            HttpHost proxyHost = new HttpHost(this.connectionProxyHost, this.connectionProxyPort);
            builder.setProxy(proxyHost);
            if (this.connectionProxyUsername != null && this.connectionProxyPassword != null) {
                BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
                credProvider.setCredentials(new AuthScope(this.connectionProxyHost, this.connectionProxyPort), (Credentials)new UsernamePasswordCredentials(this.connectionProxyUsername, this.connectionProxyPassword));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
            }
        }
        clientBuilder.setDefaultRequestConfig(builder.build());
    }

    protected void addInterceptors(@Nonnull org.apache.http.impl.client.HttpClientBuilder clientBuilder) {
        org.apache.http.impl.client.HttpClientBuilder httpClientBuilder = clientBuilder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)httpClientBuilder);
        NonnullValidator.aspectOf().validateMethodArg1((Object)httpClientBuilder, joinPoint);
        for (HttpRequestInterceptor httpRequestInterceptor : this.requestInterceptors) {
            clientBuilder.addInterceptorLast(httpRequestInterceptor);
        }
        if (this.connectionCloseAfterResponseEnabled) {
            clientBuilder.addInterceptorLast((HttpRequestInterceptor)new RequestConnectionCloseInterceptor());
        }
        for (HttpResponseInterceptor httpResponseInterceptor : this.responseInterceptors) {
            clientBuilder.addInterceptorLast(httpResponseInterceptor);
        }
    }

    protected void addCookieManagement(@Nonnull org.apache.http.impl.client.HttpClientBuilder clientBuilder) {
        org.apache.http.impl.client.HttpClientBuilder httpClientBuilder = clientBuilder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)httpClientBuilder);
        NonnullValidator.aspectOf().validateMethodArg1((Object)httpClientBuilder, joinPoint);
        if (this.cookiesEnabled) {
            if (this.cookieStore != null) {
                clientBuilder.setDefaultCookieStore(this.cookieStore);
            } else {
                clientBuilder.setDefaultCookieStore((CookieStore)new BasicCookieStore());
            }
        } else {
            clientBuilder.disableCookieManagement();
        }
    }

    private int toIntMilliseconds(int time, @Nonnull TimeUnit unit) {
        TimeUnit timeUnit = unit;
        int n = time;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)((Object)timeUnit));
        NonnullValidator.aspectOf().validateMethodArg2((Object)timeUnit, joinPoint);
        long milliseconds = TimeUnit.MILLISECONDS.convert(time, unit);
        if (milliseconds < Integer.MAX_VALUE) {
            return (int)milliseconds;
        }
        return Integer.MAX_VALUE;
    }

    private SSLContext buildSSLContext() {
        try {
            return SSLContexts.custom().setSecureRandom(new SecureRandom()).loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create SSLContext for the request", e);
        }
    }

    static {
        HttpClientBuilder.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HttpClientBuilder.java", HttpClientBuilder.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setSourceAddress", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.lang.String", "address", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 160);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setSourceInetAddress", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.net.InetAddress", "address", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 178);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setConnectionClosedAfterResponse", "com.covisint.core.support.httpclient.HttpClientBuilder", "boolean", "isClosed", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 361);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setConnectionProxyHost", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.lang.String", "host", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 382);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setConnectionProxyPort", "com.covisint.core.support.httpclient.HttpClientBuilder", "int", "port", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 403);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setConnectionProxyUsername", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.lang.String", "username", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 424);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setConnectionProxyPassword", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.lang.String", "password", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 445);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addSpanInterceptor", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.lang.String:java.lang.String", "spanHeaderName:traceHeaderName", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 458);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addXRequestorInterceptor", "com.covisint.core.support.httpclient.HttpClientBuilder", "", "", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 470);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addXRequestorApplicationInterceptor", "com.covisint.core.support.httpclient.HttpClientBuilder", "", "", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 481);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addXRealmInterceptor", "com.covisint.core.support.httpclient.HttpClientBuilder", "", "", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 492);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addAuthorizationTokenInterceptor", "com.covisint.core.support.httpclient.HttpClientBuilder", "com.google.common.base.Supplier", "tokenSupplier", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 504);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setSocketTimeout", "com.covisint.core.support.httpclient.HttpClientBuilder", "int", "timeout", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 200);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setFollowRedirects", "com.covisint.core.support.httpclient.HttpClientBuilder", "boolean", "follow", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 526);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setCookiesEnabled", "com.covisint.core.support.httpclient.HttpClientBuilder", "boolean", "enabled", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 568);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14", "getRequestInterceptors", "com.covisint.core.support.httpclient.HttpClientBuilder", "", "", "", "java.util.List"), 581);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setRequestInterceptors", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.util.List", "interceptors", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 593);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addRequestInterceptor", "com.covisint.core.support.httpclient.HttpClientBuilder", "org.apache.http.HttpRequestInterceptor", "interceptor", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 612);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14", "getResponseInterceptors", "com.covisint.core.support.httpclient.HttpClientBuilder", "", "", "", "java.util.List"), 629);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setResponseInterceptors", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.util.List", "interceptors", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 641);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addResponseInterceptor", "com.covisint.core.support.httpclient.HttpClientBuilder", "org.apache.http.HttpResponseInterceptor", "interceptor", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 660);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14", "getUserAgent", "com.covisint.core.support.httpclient.HttpClientBuilder", "", "", "", "java.lang.String"), 675);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setUserAgent", "com.covisint.core.support.httpclient.HttpClientBuilder", "java.lang.String", "agent", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 687);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setSocketTimeoutByTimeUnit", "com.covisint.core.support.httpclient.HttpClientBuilder", "int:java.util.concurrent.TimeUnit", "time:unit", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 214);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "withCookieStore", "com.covisint.core.support.httpclient.HttpClientBuilder", "org.apache.http.client.CookieStore", "store", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 710);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addSocketConfiguration", "com.covisint.core.support.httpclient.HttpClientBuilder", "org.apache.http.impl.client.HttpClientBuilder", "clientBuilder", "", "void"), 762);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addConnectionConfiguration", "com.covisint.core.support.httpclient.HttpClientBuilder", "org.apache.http.impl.client.HttpClientBuilder", "clientBuilder", "", "void"), 771);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addRequestConfiguration", "com.covisint.core.support.httpclient.HttpClientBuilder", "org.apache.http.impl.client.HttpClientBuilder", "clientBuilder", "", "void"), 782);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addInterceptors", "com.covisint.core.support.httpclient.HttpClientBuilder", "org.apache.http.impl.client.HttpClientBuilder", "clientBuilder", "", "void"), 815);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addCookieManagement", "com.covisint.core.support.httpclient.HttpClientBuilder", "org.apache.http.impl.client.HttpClientBuilder", "clientBuilder", "", "void"), 833);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toIntMilliseconds", "com.covisint.core.support.httpclient.HttpClientBuilder", "int:java.util.concurrent.TimeUnit", "time:unit", "", "int"), 854);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setSslContext", "com.covisint.core.support.httpclient.HttpClientBuilder", "javax.net.ssl.SSLContext", "context", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 237);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "socketBufferSize", "com.covisint.core.support.httpclient.HttpClientBuilder", "int", "size", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 259);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setConnectionTimeout", "com.covisint.core.support.httpclient.HttpClientBuilder", "int", "timeout", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 281);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setConnectionTimeoutByTimeUnit", "com.covisint.core.support.httpclient.HttpClientBuilder", "int:java.util.concurrent.TimeUnit", "time:unit", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 295);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setMaxConnections", "com.covisint.core.support.httpclient.HttpClientBuilder", "int", "max", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 317);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "setContentCompressionEnabled", "com.covisint.core.support.httpclient.HttpClientBuilder", "boolean", "enabled", "", "com.covisint.core.support.httpclient.HttpClientBuilder"), 339);
    }
}

