/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.client;

import com.covisint.core.http.service.client.CacheSpec;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.client.InvalidResponseContentTypeException;
import com.covisint.core.http.service.client.InvalidResponseStatusException;
import com.covisint.core.http.service.client.ResourceClient;
import com.covisint.core.http.service.client.UnsupportedRequestContentTypeException;
import com.covisint.core.http.service.client.UnsupportedResponseContentTypeException;
import com.covisint.core.http.service.client.UnsupportedStatusCodeException;
import com.covisint.core.http.service.core.HttpServiceError;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.ConstraintViolationException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceClient<T extends Resource>
implements ResourceClient<T> {
    public static final String ID_URL_VAR = "id";
    private final Logger log = LoggerFactory.getLogger(BaseResourceClient.class);
    private List<EntityWriter<T>> entityWriters;
    private List<EntityReader<T>> entityReaders;
    private HttpClient httpClient;
    private ListeningExecutorService executor;
    private MediaType crudOperationContentType;
    private String searchEndpoint;
    private UriTemplate getByIdEndpointTemplate;
    private String addEndpoint;
    private UriTemplate updateEndpointTemplate;
    private UriTemplate deleteEndpointTemplate;
    private Cache<String, Object> localCache;

    protected BaseResourceClient() {
        this.configureCache(CacheSpec.builder().maxElements(0L).build());
    }

    private void buildEndpointWithQueryParams(@Nonnull Multimap<String, String> searchCriteria, @Nullable SortCriteria sortCriteria, @Nonnull Page page, StringBuilder endpointWithQueryParams) {
        Set keys = searchCriteria.keySet();
        List sortFields = null;
        endpointWithQueryParams.append("{?");
        this.log.debug("search query params {} ", (Object)keys);
        for (String key : keys) {
            endpointWithQueryParams.append(key.trim() + "*,");
        }
        this.log.debug("pagination params {} ", (Object)page);
        endpointWithQueryParams.append("page*,");
        endpointWithQueryParams.append("pageSize*,");
        if (sortCriteria != null) {
            sortFields = sortCriteria.getSortFields();
            this.log.debug("sortFields param size is {} ", (Object)sortFields.size());
            if (sortFields.size() > 0) {
                endpointWithQueryParams.append("sortBy*");
            }
        }
        endpointWithQueryParams.append("}");
    }

    private void populateSearchCriteria(@Nonnull Multimap<String, String> searchCriteria, UriTemplate searchEndPointTemplate) {
        for (String key : searchCriteria.keySet()) {
            searchEndPointTemplate.set(key.trim(), (Object)searchCriteria.get((Object)key));
        }
    }

    private void populateSortCriteria(@Nullable SortCriteria sortCriteria, UriTemplate searchEndPointTemplate) {
        if (null != sortCriteria && !sortCriteria.getSortFields().isEmpty()) {
            List sortFieldNames = Lists.transform((List)sortCriteria.getSortFields(), (Function)new Function<SortCriteria.SortField, String>(){

                public String apply(SortCriteria.SortField field) {
                    char order = '+';
                    if (field.getSortOrder() == SortCriteria.Order.DESCENDING) {
                        order = '-';
                    }
                    return order + field.getFieldName();
                }
            });
            searchEndPointTemplate.set("sortBy", (Object)sortFieldNames);
        }
    }

    private void populatePageCriteria(Page page, UriTemplate searchEndPointTemplate) {
        searchEndPointTemplate.set("page", (Object)page.getOffset());
        searchEndPointTemplate.set("pageSize", (Object)page.getSize());
    }

    protected static final String buildSearchKey(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page) {
        StringBuilder keyBuilder = new StringBuilder();
        List sortedKeys = Ordering.natural().sortedCopy((Iterable)searchCriteria.keySet());
        for (String key : sortedKeys) {
            List sortedValues = Ordering.natural().sortedCopy((Iterable)searchCriteria.get((Object)key));
            keyBuilder.append("Filter{").append(key).append("=").append(Joiner.on((String)",").join((Iterable)sortedValues)).append("}");
        }
        List sortedFields = Ordering.from((Comparator)new Comparator<SortCriteria.SortField>(){

            @Override
            public int compare(SortCriteria.SortField left, SortCriteria.SortField right) {
                return left.getFieldName().compareTo(right.getFieldName());
            }
        }).sortedCopy((Iterable)sortCriteria.getSortFields());
        for (SortCriteria.SortField field : sortedFields) {
            keyBuilder.append("Sort{").append(field.getFieldName()).append(":").append(field.getSortOrder().toString().charAt(0)).append("}");
        }
        if (page != null) {
            keyBuilder.append(page);
        }
        return keyBuilder.toString();
    }

    protected final Cache<String, Object> getLocalCache() {
        return this.localCache;
    }

    protected String getEndpointWithQueryParams(@Nonnull Multimap<String, String> searchCriteria, @Nullable SortCriteria sortCriteria, @Nonnull Page page, @Nonnull @NotEmpty String searchResourcesEndPoint) {
        try {
            StringBuilder endpointWithQueryParams = new StringBuilder(searchResourcesEndPoint);
            this.buildEndpointWithQueryParams(searchCriteria, sortCriteria, page, endpointWithQueryParams);
            UriTemplate searchEndPointTemplate = UriTemplate.fromTemplate((String)endpointWithQueryParams.toString());
            this.populateSearchCriteria(searchCriteria, searchEndPointTemplate);
            this.populateSortCriteria(sortCriteria, searchEndPointTemplate);
            this.populatePageCriteria(page, searchEndPointTemplate);
            String searchRequest = searchEndPointTemplate.expand();
            this.log.debug("Exploded search request {}", (Object)searchRequest);
            return searchRequest;
        }
        catch (MalformedUriTemplateException | VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<T, ServiceException> get(@Nonnull @NotEmpty String id, @Nonnull HttpContext httpContext) {
        final String cacheKey = String.format("get-by-id-%s", id);
        Resource cachedResult = (Resource)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        CheckedFuture<T, ServiceException> futureResult = this.doGet(id, httpContext);
        Futures.addCallback(futureResult, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                BaseResourceClient.this.getLocalCache().put((Object)cacheKey, result);
                BaseResourceClient.this.log.debug("Successfully retrieved and cached resource for key {}", (Object)cacheKey);
            }

            public void onFailure(Throwable t) {
            }
        });
        return futureResult;
    }

    @Override
    @Nonnull
    public CheckedFuture<T, ServiceException> get(@Nonnull T resource, @Nonnull HttpContext httpContext) {
        if (resource.getVersion() == null) {
            return this.get((T)resource.getId(), httpContext);
        }
        httpContext.setAttribute("ETag", (Object)("W/" + resource.getVersion()));
        try {
            String url = this.getByIdEndpointTemplate.set(ID_URL_VAR, (Object)resource.getId()).expand();
            return this.executeWithPrecondition(resource, (HttpUriRequest)new HttpGet(url), this.crudOperationContentType, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<T, ServiceException> add(@Nonnull T resource, @Nonnull HttpContext httpContext) {
        return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPost(this.addEndpoint), this.crudOperationContentType, resource, httpContext);
    }

    @Override
    @Nonnull
    public CheckedFuture<T, ServiceException> persist(@Nonnull T resource, @Nonnull HttpContext httpContext) {
        try {
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPut(this.updateEndpointTemplate.set(ID_URL_VAR, (Object)resource.getId()).expand()), this.crudOperationContentType, resource, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<T, ServiceException> delete(@Nonnull @NotEmpty String id, @Nonnull HttpContext httpContext) {
        try {
            return this.execute((HttpUriRequest)new HttpDelete(this.deleteEndpointTemplate.set(ID_URL_VAR, (Object)id).expand()), this.crudOperationContentType, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<List<T>, ServiceException> search(@Nonnull Multimap<String, String> searchCriteria, @Nullable SortCriteria sortCriteria, @Nonnull Page page, @Nonnull HttpContext httpContext) {
        return this.search(searchCriteria, sortCriteria, page, httpContext, this.crudOperationContentType, this.searchEndpoint);
    }

    @Override
    public CheckedFuture<List<T>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, @Nonnull Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        final String cacheKey = BaseResourceClient.buildSearchKey(searchCriteria, sortCriteria, page);
        List cachedResult = (List)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(this.getEndpointWithQueryParams(searchCriteria, sortCriteria, page, searchResourcesEndPoint)), mediaType, httpContext);
        Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new FutureCallback<List<T>>(){

            public void onSuccess(List<T> result) {
                BaseResourceClient.this.getLocalCache().put((Object)cacheKey, result);
                BaseResourceClient.this.log.debug("Successfully retrieved and cached search results for key {}", (Object)cacheKey);
            }

            public void onFailure(Throwable t) {
            }
        });
        return futureResult;
    }

    @Nonnull
    protected CheckedFuture<T, ServiceException> doGet(@Nonnull @NotEmpty String id, @Nonnull HttpContext httpContext) {
        try {
            return this.execute((HttpUriRequest)new HttpGet(this.getByIdEndpointTemplate.set(ID_URL_VAR, (Object)id).expand()), this.crudOperationContentType, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    protected final CheckedFuture executeWithBody(@Nonnull HttpEntityEnclosingRequestBase request, @Nonnull MediaType contentType, @Nonnull MediaType acceptContentType, @Nonnull Object body, @Nonnull HttpContext httpContext) {
        HttpEntity entity = this.buildEntity(contentType, body);
        request.setEntity(entity);
        request.addHeader(entity.getContentType());
        return this.execute((HttpUriRequest)request, acceptContentType, httpContext);
    }

    protected final CheckedFuture executeWithBody(@Nonnull HttpEntityEnclosingRequestBase request, @Nonnull MediaType contentType, @Nonnull Object body, @Nonnull HttpContext httpContext) {
        HttpEntity entity = this.buildEntity(contentType, body);
        request.setEntity(entity);
        request.addHeader(entity.getContentType());
        return this.execute((HttpUriRequest)request, contentType, httpContext);
    }

    protected final CheckedFuture executeWithPrecondition(@Nonnull T resource, final @Nonnull HttpUriRequest request, final @Nonnull MediaType contentType, final @Nonnull HttpContext httpContext) {
        ListenableFuture task = this.executor.submit(new Callable((Resource)resource){
            final /* synthetic */ Resource val$resource;
            {
                this.val$resource = resource;
            }

            public Object call() throws Exception {
                String etag = (String)httpContext.getAttribute("ETag");
                if (StringSupport.trimOrNull((String)etag) == null) {
                    return BaseResourceClient.this.execute(request, contentType, httpContext);
                }
                request.setHeader((Header)new BasicHeader("ETag", etag));
                request.setHeader((Header)new BasicHeader("Accept", contentType.toString()));
                HttpResponse response = BaseResourceClient.this.httpClient.execute(request, httpContext);
                Object result = BaseResourceClient.this.handleResponse(request, response, httpContext);
                if (result.equals(304)) {
                    return this.val$resource;
                }
                return result;
            }
        });
        return Futures.makeChecked((ListenableFuture)task, (Function)ExceptionMapper.INSTANCE);
    }

    protected final CheckedFuture execute(final @Nonnull HttpUriRequest request, final @Nonnull MediaType contentType, final @Nonnull HttpContext httpContext) {
        ListenableFuture task = this.executor.submit(new Callable(){

            public Object call() throws Exception {
                request.setHeader((Header)new BasicHeader("Accept", contentType.toString()));
                HttpResponse response = BaseResourceClient.this.httpClient.execute(request, httpContext);
                return BaseResourceClient.this.handleResponse(request, response, httpContext);
            }
        });
        return Futures.makeChecked((ListenableFuture)task, (Function)ExceptionMapper.INSTANCE);
    }

    final void setEntityReaders(@Nonnull @NonnullElements List<EntityReader> readers) {
        this.entityReaders = new ImmutableList.Builder().addAll(Iterables.filter(readers, (Predicate)Predicates.notNull())).build();
    }

    final void setEntityWriters(@Nonnull @NonnullElements List<EntityWriter> writers) {
        this.entityWriters = new ImmutableList.Builder().addAll(Iterables.filter(writers, (Predicate)Predicates.notNull())).build();
    }

    final void setHttpClient(@Nonnull HttpClient client) {
        this.httpClient = client;
    }

    final void setExecutorService(@Nonnull ListeningExecutorService service) {
        this.executor = service;
    }

    final void setCrudContentType(@Nonnull MediaType contentType) {
        this.crudOperationContentType = contentType;
    }

    final void setGetByIdEndpointTemplate(@Nonnull UriTemplate endpoint) {
        this.getByIdEndpointTemplate = this.isValidByIdTemplate(endpoint);
    }

    final void setAddEndpoint(@Nonnull @NotEmpty String endpoint) {
        this.addEndpoint = endpoint;
    }

    final void setUpdateEndpointTemplate(@Nonnull UriTemplate endpoint) {
        this.updateEndpointTemplate = this.isValidByIdTemplate(endpoint);
    }

    final void setDeleteEndpointTemplate(@Nonnull UriTemplate endpoint) {
        this.deleteEndpointTemplate = this.isValidByIdTemplate(endpoint);
    }

    final void setSearchEndpoint(@Nonnull @NotEmpty String endpoint) {
        this.searchEndpoint = endpoint;
    }

    final void configureCache(@Nonnull CacheSpec config) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (config.getMaxWeight() > 0L && config.getWeigher() != null) {
            builder.maximumWeight(config.getMaxWeight()).weigher(config.getWeigher());
        } else {
            builder.maximumSize(config.getMaxElements());
        }
        if (config.getExpiration() > 0L) {
            if (config.getExpirationMode() == CacheSpec.ExpirationMode.AFTER_ACCESS) {
                builder.expireAfterAccess(config.getExpiration(), TimeUnit.MILLISECONDS);
            } else if (config.getExpirationMode() == CacheSpec.ExpirationMode.AFTER_WRITE) {
                builder.expireAfterAccess(config.getExpiration(), TimeUnit.MILLISECONDS);
            }
        }
        this.localCache = builder.build();
    }

    private UriTemplate isValidByIdTemplate(@Nonnull UriTemplate template) {
        String[] variables = template.getVariables();
        if (variables.length != 1) {
            throw new ConstraintViolationException("endpoint template must contain a single variable call id");
        }
        if (!ID_URL_VAR.equals(variables[0])) {
            throw new ConstraintViolationException("endpoint template variable must be called id");
        }
        return template;
    }

    private HttpEntity buildEntity(@Nonnull MediaType requestedType, @Nonnull Object body) {
        EntityWriter entityWriter = this.getEntityWriter(body.getClass(), requestedType);
        try {
            this.log.debug("Preparing to write out object of type {} with entity writer of type {}", (Object)body.getClass().getName(), (Object)entityWriter.getClass().getName());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            MediaType outputMediaType = entityWriter.write(requestedType, body, (OutputStream)output);
            this.log.debug("Wrote out object of type {} with entity writer of type {}", (Object)body.getClass().getName(), (Object)entityWriter.getClass().getName());
            return new ByteArrayEntity(output.toByteArray(), ContentType.parse((String)outputMediaType.toString()));
        }
        catch (EntityWriterException e) {
            this.log.error("Unable to write out object of type {} with an entity writer of type {}", new Object[]{body.getClass().getName(), entityWriter.getClass().getName(), e});
            throw e;
        }
    }

    @Nonnull
    private Object handleResponse(@Nonnull HttpUriRequest request, @Nonnull HttpResponse response, @Nonnull HttpContext httpContext) {
        this.log.debug("Processing response of {} from {}", (Object)request.getMethod(), httpContext.getAttribute("http.target_host"));
        StatusLine status = response.getStatusLine();
        int statusCode = status.getStatusCode();
        this.log.debug("Response status code was {} with a status reason of {}", (Object)statusCode, (Object)status.getReasonPhrase());
        if (statusCode >= 100 && statusCode <= 199) {
            return this.handle100Response(request, response, httpContext, statusCode);
        }
        if (statusCode >= 200 && statusCode <= 299) {
            return this.handle200Response(request, response, httpContext, statusCode);
        }
        if (statusCode >= 300 && statusCode <= 399) {
            return this.handle300Response(request, response, httpContext, statusCode);
        }
        if (statusCode >= 400 && statusCode <= 499) {
            return this.handle400Exception(request, response, httpContext, statusCode);
        }
        if (statusCode >= 500 && statusCode <= 599) {
            throw this.create500Exception(request, response, httpContext, statusCode);
        }
        throw new InvalidResponseStatusException(statusCode);
    }

    private Object handle100Response(@Nonnull HttpUriRequest request, @Nonnull HttpResponse response, @Nonnull HttpContext httpContext, int statusCode) {
        throw new UnsupportedStatusCodeException(statusCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object handle200Response(@Nonnull HttpUriRequest request, @Nonnull HttpResponse response, @Nonnull HttpContext httpContext, int statusCode) {
        if (statusCode == 204) {
            this.log.debug("Response status code of {} indicates no body to read, returning", (Object)statusCode);
            return null;
        }
        HttpEntity responseEntity = response.getEntity();
        MediaType contentType = this.getResponseContentType(responseEntity);
        EntityReader reader = this.getEntityReader(contentType);
        this.log.debug("Response entity, of content type {}, is {} bytes in size. Preparing to read it with an entity reader of type {}", new Object[]{contentType, responseEntity.getContentLength(), reader.getClass().getName()});
        try (InputStream body = response.getEntity().getContent();){
            Object unmarshalledBody = reader.read(contentType, body);
            this.log.debug("Read body into an object of type {}", (Object)unmarshalledBody.getClass().getName());
            Object object = unmarshalledBody;
            return object;
        }
        catch (IOException e) {
            this.log.error("Unable to read response body", (Throwable)e);
            throw new EntityReaderException("Unable to read response");
        }
    }

    private Object handle300Response(@Nonnull HttpUriRequest request, @Nonnull HttpResponse response, @Nonnull HttpContext httpContext, int statusCode) {
        if (statusCode == 304) {
            return statusCode;
        }
        throw new UnsupportedStatusCodeException(statusCode);
    }

    private Object handle400Exception(@Nonnull HttpUriRequest request, @Nonnull HttpResponse response, @Nonnull HttpContext httpContext, int statusCode) {
        if (statusCode == 403 || statusCode == 401) {
            throw new ServiceException("framework:security", response.getStatusLine().getReasonPhrase());
        }
        EntityReader entityReader = this.getEntityReader(JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE);
        try {
            InputStream content = response.getEntity().getContent();
            HttpServiceError error = (HttpServiceError)entityReader.read(JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE, content);
            throw new ServiceException(error.getApiStatusCode(), error.getApiMessage());
        }
        catch (IOException e) {
            this.log.error("Unable to read response body", (Throwable)e);
            throw new EntityReaderException("Unable to read response");
        }
    }

    private ServiceException create500Exception(@Nonnull HttpUriRequest request, @Nonnull HttpResponse response, @Nonnull HttpContext httpContext, int statusCode) {
        EntityReader entityReader = this.getEntityReader(JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE);
        try {
            InputStream content = response.getEntity().getContent();
            HttpServiceError error = (HttpServiceError)entityReader.read(JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE, content);
            return new ServiceException(error.getApiStatusCode(), error.getApiMessage());
        }
        catch (IOException e) {
            this.log.error("Unable to read response body", (Throwable)e);
            return new EntityReaderException("Unable to read response");
        }
    }

    private EntityWriter getEntityWriter(Class<?> clazz, MediaType contentType) {
        for (EntityWriter<T> writer : this.entityWriters) {
            if (!writer.isWritable(clazz, contentType)) continue;
            return writer;
        }
        throw new UnsupportedRequestContentTypeException(contentType);
    }

    @Nonnull
    private MediaType getResponseContentType(@Nonnull HttpEntity responseEntity) {
        Header contentTypeHeader = responseEntity.getContentType();
        if (contentTypeHeader == null) {
            this.log.warn("Invalid response from server, no Content-Type header present");
            throw new InvalidResponseContentTypeException();
        }
        String contentType = StringSupport.trimOrNull((String)contentTypeHeader.getValue());
        if (contentType == null) {
            this.log.warn("Invalid response from server, Content-Type header was present but empty");
            throw new InvalidResponseContentTypeException();
        }
        try {
            MediaType mediaType = MediaType.parse((String)contentType);
            this.log.debug("Content type of response is {}", (Object)contentType);
            return mediaType;
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Invalid response from server, Content-Type header had the unparsable value of {}", (Object)contentType);
            throw new InvalidResponseContentTypeException(contentType);
        }
    }

    private EntityReader getEntityReader(MediaType contentType) {
        for (EntityReader<T> reader : this.entityReaders) {
            if (!reader.isReadable(contentType)) continue;
            return reader;
        }
        throw new UnsupportedResponseContentTypeException(contentType);
    }

    private static class ExceptionMapper
    implements Function<Exception, ServiceException> {
        public static final ExceptionMapper INSTANCE = new ExceptionMapper();

        private ExceptionMapper() {
        }

        public ServiceException apply(Exception input) {
            Throwable e = input;
            while (!(e instanceof ServiceException) && e.getCause() != null) {
                e = e.getCause();
            }
            if (e instanceof ServiceException) {
                return (ServiceException)e;
            }
            return new ClientException(e.getMessage());
        }
    }
}

