/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.client;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.core.http.service.client.CacheSpec;
import com.covisint.core.http.service.client.ClientInitializationContext;
import com.covisint.core.http.service.client.HttpProxySpec;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.HttpClient;

public abstract class BaseResourceClientFactory<B extends BaseResourceClientBuilder<B, C>, C extends BaseResourceClient<?>> {
    private volatile C client;
    private final String serviceBaseUrl;
    private Integer maxConcurrentRequests = 100;
    private String sourceAddress;
    private Integer socketTimeout;
    private Integer socketBufferSize;
    private Integer connectionTimeout;
    private Boolean connectionCloseAfterResponseEnabled;
    private Boolean followRedirects;
    private int maxRedirects = 5;
    private Boolean cookiesEnabled;
    private Boolean contentCompressionEnabled;
    private Charset contentCharSet;
    private CacheSpec cacheSpec;
    private HttpProxySpec proxySpec;

    public BaseResourceClientFactory(@Nonnull String serviceUrl) {
        this.serviceBaseUrl = serviceUrl;
    }

    @Nonnull
    protected B populateBaseBuilder(@Nonnull B builder) {
        ((BaseResourceClientBuilder)builder).setServiceBaseUrl(this.getServiceBaseUrl());
        ((BaseResourceClientBuilder)builder).setHttpClient(this.buildHttpClient());
        ((BaseResourceClientBuilder)builder).setExecutorService(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.getMaxConcurrentRequests())));
        ((BaseResourceClientBuilder)builder).setCacheSpec(this.getCacheSpec());
        return builder;
    }

    protected void setConnectionOptions(HttpClientBuilder builder) {
        if (this.connectionTimeout != null) {
            builder.setConnectionTimeout(this.connectionTimeout.intValue());
        }
        if (this.connectionCloseAfterResponseEnabled != null) {
            builder.setConnectionClosedAfterResponse(this.connectionCloseAfterResponseEnabled.booleanValue());
        }
    }

    protected void setSocketOptions(HttpClientBuilder builder) {
        if (this.socketTimeout != null) {
            builder.setSocketTimeout(this.socketTimeout.intValue());
        }
        if (this.socketBufferSize != null) {
            builder.socketBufferSize(this.socketBufferSize.intValue());
        }
    }

    @Nonnull
    protected HttpClient buildHttpClient() {
        HttpClientBuilder builder = new HttpClientBuilder();
        this.setSocketOptions(builder);
        this.setConnectionOptions(builder);
        if (this.maxConcurrentRequests != null) {
            builder.setMaxConnections(this.maxConcurrentRequests.intValue());
        }
        if (this.sourceAddress != null) {
            builder.setSourceAddress(this.sourceAddress);
        }
        if (this.followRedirects != null) {
            builder.setFollowRedirects(this.followRedirects.booleanValue());
            builder.setMaxRedirects(this.maxRedirects);
        }
        if (this.cookiesEnabled != null) {
            builder.setCookiesEnabled(this.cookiesEnabled.booleanValue());
        }
        if (this.contentCompressionEnabled != null) {
            builder.setContentCompressionEnabled(this.contentCompressionEnabled.booleanValue());
        }
        if (this.proxySpec != null) {
            builder.setConnectionProxyHost(this.proxySpec.getHost());
            builder.setConnectionProxyPort(this.proxySpec.getPort());
            if (StringSupport.trimOrNull((String)this.proxySpec.getUsername()) != null) {
                builder.setConnectionProxyUsername(this.proxySpec.getUsername());
                builder.setConnectionProxyPassword(this.proxySpec.getPassword());
            }
        }
        builder.addSpanInterceptor("X-Span", "X-Trace");
        builder.addXRealmInterceptor();
        builder.addXRequestorInterceptor();
        builder.addXRequestorApplicationInterceptor();
        return this.populateHttpClientBuilder(builder).build();
    }

    @Nonnull
    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        return builder;
    }

    @Nonnull
    protected abstract B newBuilder();

    @Nonnull
    protected abstract C buildResourceClient(@Nonnull B var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C create() {
        C instance = this.client;
        if (instance == null) {
            BaseResourceClientFactory baseResourceClientFactory = this;
            synchronized (baseResourceClientFactory) {
                instance = this.client;
                if (instance == null) {
                    ClientInitializationContext.setClientFactory(this);
                    B builder = this.populateBaseBuilder(this.newBuilder());
                    this.client = instance = this.buildResourceClient(builder);
                }
            }
        }
        return instance;
    }

    @Nullable
    public final String getSourceAddress() {
        return this.sourceAddress;
    }

    @Nonnull
    public final BaseResourceClientFactory<B, C> setSourceAddress(@Nonnull String address) {
        this.sourceAddress = address;
        return this;
    }

    @Nullable
    public final Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public final BaseResourceClientFactory<B, C> setSocketTimeout(@Nonnull Integer timeout) {
        this.socketTimeout = timeout;
        return this;
    }

    @Nullable
    public final Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public final BaseResourceClientFactory<B, C> setSocketBufferSize(@Nonnull Integer bufferSize) {
        this.socketBufferSize = bufferSize;
        return this;
    }

    @Nullable
    public final Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public final BaseResourceClientFactory<B, C> setConnectionTimeout(@Nonnull Integer timeout) {
        this.connectionTimeout = timeout;
        return this;
    }

    @Nullable
    public final Boolean getConnectionCloseAfterResponseEnabled() {
        return this.connectionCloseAfterResponseEnabled;
    }

    public final BaseResourceClientFactory<B, C> setConnectionCloseAfterResponseEnabled(@Nonnull Boolean enabled) {
        this.connectionCloseAfterResponseEnabled = enabled;
        return this;
    }

    @Nullable
    public final Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public final BaseResourceClientFactory<B, C> setFollowRedirects(@Nonnull Boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    @Nullable
    public final int getMaxRedirects() {
        return this.maxRedirects;
    }

    public final BaseResourceClientFactory<B, C> setMaxRedirects(@Nonnull int max) {
        this.maxRedirects = max;
        return this;
    }

    @Nullable
    public final Boolean getCookiesEnabled() {
        return this.cookiesEnabled;
    }

    public final BaseResourceClientFactory<B, C> setCookiesEnabled(@Nonnull Boolean enabled) {
        this.cookiesEnabled = enabled;
        return this;
    }

    @Nullable
    public final Boolean getContentCompressionEnabled() {
        return this.contentCompressionEnabled;
    }

    public final BaseResourceClientFactory<B, C> setContentCompressionEnabled(@Nonnull Boolean enabled) {
        this.contentCompressionEnabled = enabled;
        return this;
    }

    @Nullable
    public final Charset getContentCharSet() {
        return this.contentCharSet;
    }

    public final BaseResourceClientFactory<B, C> setContentCharSet(@Nonnull Charset charset) {
        this.contentCharSet = charset;
        return this;
    }

    @Nullable
    public final Integer getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Nonnull
    public final BaseResourceClientFactory<B, C> setMaxConcurrentRequests(@Nonnull Integer max) {
        this.maxConcurrentRequests = max;
        return this;
    }

    public final CacheSpec getCacheSpec() {
        return this.cacheSpec;
    }

    @Nonnull
    public final BaseResourceClientFactory<B, C> setCacheSpec(@Nonnull CacheSpec config) {
        this.cacheSpec = config;
        return this;
    }

    public final HttpProxySpec getHttpProxySpec() {
        return this.proxySpec;
    }

    @Nonnull
    public final BaseResourceClientFactory<B, C> setHttpProxySpec(@Nonnull HttpProxySpec config) {
        this.proxySpec = config;
        return this;
    }

    @Nonnull
    public final String getServiceBaseUrl() {
        return this.serviceBaseUrl;
    }
}

