/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy;

import com.covisint.core.http.service.core.NamedResourceReference;
import com.covisint.core.http.service.core.ResourceReferenceNode;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.legacy.InternationalString;
import com.covisint.platform.legacy.InternationalStringFetcher;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public abstract class AbstractHierarchyJdbcDao
extends JdbcDaoSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHierarchyJdbcDao.class);

    @Nonnull
    @NotEmpty
    protected abstract String getHierarchySql();

    protected abstract String getNameSql();

    protected abstract String getDescriptionSql();

    protected abstract MapSqlParameterSource getSqlParameterArgs(String var1);

    @Nonnull
    private Map<String, String> toMap(@Nonnull Collection<InternationalString> strings) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (InternationalString string : strings) {
            map.put(string.getLang(), string.getValue());
        }
        return map;
    }

    private ResourceReferenceNode<NamedResourceReference> buildTree(Map<String, ResourceReferenceNode> mappedReferences, Multimap<String, InternationalString> idMappedNames, Multimap<String, InternationalString> idMappedDescriptions, ResourceReferenceNode<NamedResourceReference> rootNode, ResourceReferenceNode<NamedResourceReference> refNode, NamedResourceReference currentNRes, NamedResourceReference currentPRes) {
        String currentNodeId = currentNRes.getId();
        currentNRes.setName(this.toMap(idMappedNames.get((Object)currentNodeId)));
        currentNRes.setDescription(this.toMap(idMappedDescriptions.get((Object)currentNodeId)));
        ResourceReferenceNode root = rootNode;
        if (refNode.getParent() != null) {
            String currentParentId = currentPRes.getId();
            currentPRes.setName(this.toMap(idMappedNames.get((Object)currentParentId)));
            currentPRes.setDescription(this.toMap(idMappedDescriptions.get((Object)currentParentId)));
            if (mappedReferences.get(currentParentId) != null) {
                mappedReferences.get(currentParentId).addChild(mappedReferences.get(currentNodeId));
            } else {
                root = mappedReferences.get(refNode.getValue().getId());
            }
        } else {
            root = mappedReferences.get(refNode.getValue().getId());
        }
        return root;
    }

    @Nonnull
    private Multimap<String, InternationalString> toIdMultimap(@Nonnull @NonnullElements Future<List<InternationalString>> values, String sql) {
        try {
            ArrayListMultimap mm = ArrayListMultimap.create();
            if (sql != null) {
                for (InternationalString value : values.get()) {
                    mm.put((Object)value.getEntityId(), (Object)value);
                }
            }
            return mm;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Execution error processing async tasks.", (Throwable)e);
            throw new ServiceException("framework", e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ResourceReferenceNode<NamedResourceReference> getHierarchy(@Nonnull @NotEmpty String resourceId) {
        ExecutorService localExecutor = Executors.newFixedThreadPool(2);
        try {
            ResourceReferenceNode<NamedResourceReference> root = null;
            String sql = this.getHierarchySql();
            LOG.debug("Hierarchy query to be executed: {}", (Object)sql);
            List preprocessed = new NamedParameterJdbcTemplate((JdbcOperations)this.getJdbcTemplate()).query(sql, (SqlParameterSource)this.getSqlParameterArgs(resourceId), (RowMapper)new ResourceReferenceNodeMapper());
            ImmutableMap mapped = Maps.uniqueIndex((Iterable)preprocessed, (Function)new Function<ResourceReferenceNode, String>(){

                public String apply(ResourceReferenceNode from) {
                    if (from == null) {
                        return null;
                    }
                    return from.getValue().getId();
                }
            });
            if (mapped.size() > 0) {
                Future<List<InternationalString>> nameFuture = localExecutor.submit(new InternationalStringFetcher(this.getJdbcTemplate(), this.getNameSql(), Lists.newArrayList(mapped.keySet())));
                Future<List<InternationalString>> descriptionFuture = localExecutor.submit(new InternationalStringFetcher(this.getJdbcTemplate(), this.getDescriptionSql(), Lists.newArrayList(mapped.keySet())));
                Multimap<String, InternationalString> idMappedNames = this.toIdMultimap(nameFuture, this.getNameSql());
                Multimap<String, InternationalString> idMappedDescriptions = this.toIdMultimap(descriptionFuture, this.getDescriptionSql());
                for (ResourceReferenceNode node : preprocessed) {
                    root = this.buildTree((Map<String, ResourceReferenceNode>)mapped, idMappedNames, idMappedDescriptions, root, (ResourceReferenceNode<NamedResourceReference>)node, node.getValue(), node.getParent());
                }
            }
            ResourceReferenceNode<NamedResourceReference> resourceReferenceNode = root;
            return resourceReferenceNode;
        }
        finally {
            localExecutor.shutdownNow();
        }
    }

    private static final class ResourceReferenceNodeMapper
    implements RowMapper<ResourceReferenceNode> {
        private static final String COLUMN_NAME_ID = "ID";
        private static final String COLUMN_NAME_TYPE = "TYPE";
        private static final String COLUMN_NAME_REALM = "REALM";
        private static final String COLUMN_NAME_PARENT_ID = "PARENT_ID";

        private ResourceReferenceNodeMapper() {
        }

        @Nonnull
        public ResourceReferenceNode mapRow(@Nonnull ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString(COLUMN_NAME_ID);
            String type = rs.getString(COLUMN_NAME_TYPE);
            String realm = rs.getString(COLUMN_NAME_REALM);
            String parentId = rs.getString(COLUMN_NAME_PARENT_ID);
            NamedResourceReference node = new NamedResourceReference(id, type, realm, null, null);
            NamedResourceReference parent = new NamedResourceReference(parentId, type, realm, null, null);
            return new ResourceReferenceNode(node, parent);
        }
    }
}

