/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy;

import com.covisint.core.http.service.core.InvocationContext;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.legacy.InternationalString;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public final class InternationalStringFetcher
implements Callable<List<InternationalString>> {
    private final String sql;
    private final List<String> ids;
    private final JdbcTemplate jdbcTemplate;
    private final Logger log = LoggerFactory.getLogger(InternationalStringFetcher.class);

    public InternationalStringFetcher(@Nonnull JdbcTemplate newJdbcTemplate, @Nonnull @NotEmpty String newSql, @Nonnull @NotEmpty List<String> newIds) {
        this.sql = newSql;
        this.ids = newIds;
        this.jdbcTemplate = newJdbcTemplate;
    }

    @Override
    public List<InternationalString> call() throws Exception {
        if (this.ids == null || this.ids.isEmpty()) {
            return new ArrayList<InternationalString>();
        }
        this.log.debug("Retrieving i18n strings for ids {} using SQL {}", this.ids, (Object)this.sql);
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("ids", this.ids).addValue("realm", (Object)InvocationContext.getRealmId());
        return new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate).query(this.sql, (SqlParameterSource)args, (RowMapper)new RowMapper<InternationalString>(){

            public InternationalString mapRow(ResultSet rs, int rowNum) throws SQLException {
                String serviceId = rs.getString("ID");
                String lang = rs.getString("LANG");
                String value = rs.getString("VALUE");
                return new InternationalString(serviceId, lang, value);
            }
        });
    }
}

