/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy;

import com.covisint.core.http.service.core.InvocationContext;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public final class LegacyResourceJdbcDao {
    private static final String SQL_CHECK_PERSON_EXISTS = "SELECT COUNT(1) FROM USERS WHERE GBL_COV_USER_ID = :personId AND REALM_CODE = :realm";
    private static final String SQL_CHECK_PERSON_WITH_STATUS_EXISTS = "SELECT COUNT(1) FROM USERS WHERE GBL_COV_USER_ID = :personId AND REALM_CODE = :realm AND STATUS_ENUM = :status";
    private static final String SQL_CHECK_PERSON_WITH_PREF_LANG_EXISTS = "SELECT COUNT(1) FROM USERS WHERE GBL_COV_USER_ID = :personId AND REALM_CODE = :realm AND PREFERRED_LANGUAGE = (SELECT LANGUAGE_ID FROM LANGUAGES WHERE ISO_LOCALE = :preferredLanguage)";
    private static final String SQL_CHECK_ORGANIZATION_EXISTS = "SELECT COUNT(1) FROM ORGANIZATIONS WHERE GBL_COV_ORG_ID = :organizationId AND REALM_CODE = :realm";
    private static final String SQL_CHECK_PACKAGE_EXISTS = "SELECT COUNT(1) FROM PACKAGES WHERE GBL_COV_PKG_ID = :packageId AND REALM_CODE = :realm";
    private static final String SQL_CHECK_BUSINESS_UNIT_EXISTS = "SELECT COUNT(1) FROM BUSINESS_UNITS WHERE NAME = :businessUnitId";
    private static final String SQL_CHECK_PERSON_PACKAGE_GRANT_EXISTS = "SELECT COUNT(1) FROM USER_PKG_GRANTS UPG, USERS U, PACKAGES P WHERE U.GBL_COV_USER_ID = :personId AND U.USER_ID = UPG.USER_ID AND U.REALM_CODE = :realm AND P.GBL_COV_PKG_ID = :packageId AND P.PACKAGE_ID = UPG.PACKAGE_ID AND P.REALM_CODE = :realm";
    private static final String SQL_CHECK_ORGANIZATION_PACKAGE_GRANT_EXISTS = "SELECT COUNT(1) FROM ORG_PKG_GRANTS OPG, ORGANIZATIONS O, PACKAGES P WHERE O.GBL_COV_ORG_ID = :organizationId AND O.ORGANIZATION_ID = OPG.ORGANIZATION_ID AND O.REALM_CODE = :realm AND P.GBL_COV_PKG_ID = :packageId AND P.PACKAGE_ID = OPG.PACKAGE_ID AND P.REALM_CODE = :realm";
    private static final String SQL_CHECK_GROUP_BY_CATEGORY_NAME_LANG = "SELECT COUNT(1) FROM GROUPS_TL WHERE GROUP_NAME = :groupName AND REALM_CODE = :realm AND LANGUAGE = (SELECT LANGUAGE_ID FROM LANGUAGES L WHERE LOWER(L.ISO_LOCALE) = LOWER(:groupLang))";
    private static final String SQL_CHECK_LANGUAGE_EXISTS = "SELECT COUNT(1) FROM LANGUAGES WHERE ISO_LOCALE = :languageISOCode";
    private static final String SQL_CHECK_TIME_ZONE_EXISTS = "SELECT COUNT(1) FROM TIME_ZONE_REF WHERE JAVA_ID = :javaId";
    private static final String SQL_CHECK_CURRENCY_EXISTS = "SELECT COUNT(1) FROM CURRENCY WHERE ABBREVIATION = :abbreviation";
    private static final String SQL_CHECK_SERVICE_EXISTS = "SELECT COUNT(1) FROM SERVICES WHERE SERVICE_ID = :serviceId AND REALM_CODE = :realm";
    private static final String SQL_CHECK_SERVICES_EXIST = "SELECT SERVICE_ID FROM SERVICES WHERE SERVICE_ID IN ( :serviceIds ) AND REALM_CODE = :realm";
    private static final String SQL_CHECK_REALM_EXISTS = "SELECT COUNT(1) FROM REALM WHERE REALM_CODE = :realm";
    private static final String SQL_CHECK_COUNTRY_CODE_EXISTS = "SELECT COUNT(1) FROM COUNTRY_REF WHERE COUNTRY_CODE = :countryCode";
    private static final String SQL_CHECK_TERMS_AND_CONDITIONS_IDS_EXIST = "SELECT TAC_ID FROM TERMS_AND_CONDITIONS WHERE TAC_ID IN (:tacIds)";

    private LegacyResourceJdbcDao() {
    }

    public static boolean validatePersonExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String personId) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("personId", (Object)personId).addValue("realm", (Object)InvocationContext.getRealmId());
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_PERSON_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validatePersonExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String personId, int status) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("personId", (Object)personId).addValue("realm", (Object)InvocationContext.getRealmId()).addValue("status", (Object)status);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_PERSON_WITH_STATUS_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validatePersonExistsWithPreferredLanguage(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String personId, @Nonnull @NotEmpty String preferredLanguage) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("personId", (Object)personId).addValue("realm", (Object)InvocationContext.getRealmId()).addValue("preferredLanguage", (Object)preferredLanguage);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_PERSON_WITH_PREF_LANG_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateOrganizationExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String organizationId) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("organizationId", (Object)organizationId).addValue("realm", (Object)InvocationContext.getRealmId());
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_ORGANIZATION_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validatePackageExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String packageId) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("packageId", (Object)packageId).addValue("realm", (Object)InvocationContext.getRealmId());
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_PACKAGE_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateBusinessUnitExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String businessUnitId) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("businessUnitId", (Object)businessUnitId);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_BUSINESS_UNIT_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validatePersonPackageGrantExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String personId, @Nonnull @NotEmpty String packageId) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("realm", (Object)InvocationContext.getRealmId()).addValue("personId", (Object)personId).addValue("packageId", (Object)packageId);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_PERSON_PACKAGE_GRANT_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateOrganizationPackageGrantExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String organizationId, @Nonnull @NotEmpty String packageId) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("realm", (Object)InvocationContext.getRealmId()).addValue("organizationId", (Object)organizationId).addValue("packageId", (Object)packageId);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_ORGANIZATION_PACKAGE_GRANT_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateGroupExistsForNameAndLang(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String language, @Nonnull @NotEmpty String name) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("groupLang", (Object)language).addValue("groupName", (Object)name).addValue("realm", (Object)InvocationContext.getRealmId());
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_GROUP_BY_CATEGORY_NAME_LANG, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateLanguageExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String languageISOCode) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("languageISOCode", (Object)languageISOCode);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_LANGUAGE_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateTimeZoneExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String javaId) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("javaId", (Object)javaId);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_TIME_ZONE_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateCurrencyExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String abbreviation) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("abbreviation", (Object)abbreviation);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_CURRENCY_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateServiceExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String serviceId) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("serviceId", (Object)serviceId).addValue("realm", (Object)InvocationContext.getRealmId());
        if (Longs.tryParse((String)serviceId) == null) {
            return false;
        }
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_SERVICE_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static List<String> validateServicesExist(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NonnullElements Collection<String> serviceIds) {
        ArrayList<String> serviceIdsToValidate = new ArrayList<String>();
        for (String serviceId : serviceIds) {
            if (Longs.tryParse((String)serviceId) == null) continue;
            serviceIdsToValidate.add(serviceId);
        }
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("serviceIds", serviceIdsToValidate).addValue("realm", (Object)InvocationContext.getRealmId());
        return new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForList(SQL_CHECK_SERVICES_EXIST, (SqlParameterSource)args, String.class);
    }

    public static boolean validateRealmExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String realm) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("realm", (Object)realm);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_REALM_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static boolean validateCountryCodeExists(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NotEmpty String countryCode) {
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("countryCode", (Object)countryCode);
        Long count = (Long)new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForObject(SQL_CHECK_COUNTRY_CODE_EXISTS, (SqlParameterSource)args, Long.class);
        return count == 1L;
    }

    public static List<String> validateTermsAndConditionsIdsExist(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull @NonnullElements Collection<String> tacIds) {
        ArrayList<String> tacIdsToValidate = new ArrayList<String>();
        for (String tacId : tacIds) {
            if (Longs.tryParse((String)tacId) == null) continue;
            tacIdsToValidate.add(tacId);
        }
        MapSqlParameterSource args = new MapSqlParameterSource().addValue("tacIds", tacIdsToValidate);
        return new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate).queryForList(SQL_CHECK_TERMS_AND_CONDITIONS_IDS_EXIST, (SqlParameterSource)args, String.class);
    }
}

