/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy.address;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

final class CountrySupport {
    private static Set<String> iso3166CountryCodes;

    private CountrySupport() {
    }

    private static synchronized void loadCountryCodes() {
        if (iso3166CountryCodes != null) {
            return;
        }
        iso3166CountryCodes = new HashSet<String>(Arrays.asList(Locale.getISOCountries()));
    }

    static boolean isValidCountryCode(@Nonnull @NotEmpty String isoCountryCode) {
        if (iso3166CountryCodes == null) {
            CountrySupport.loadCountryCodes();
        }
        return iso3166CountryCodes.contains(isoCountryCode);
    }
}

