/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy.phone;

import com.covisint.core.http.service.core.Resource;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Phones
implements Serializable {
    public static final String PHONE_TYPE_MAIN = "main";
    public static final String PHONE_TYPE_MOBILE = "mobile";
    public static final String PHONE_TYPE_FAX = "fax";
    public static final Set<String> SUPPORTED_PHONE_TYPES = ImmutableSet.of((Object)"main", (Object)"mobile", (Object)"fax");
    private static final long serialVersionUID = 8129809789559038603L;
    private String main;
    private String mobile;
    private String fax;
    private Map<String, String> phones = new HashMap<String, String>();
    private Resource owner;

    public void init() {
        this.setByType(PHONE_TYPE_MAIN, this.main);
        this.setByType(PHONE_TYPE_MOBILE, this.mobile);
        this.setByType(PHONE_TYPE_FAX, this.fax);
    }

    @Nullable
    public String getByType(@Nonnull String phoneType) {
        return this.phones.get(phoneType.toLowerCase());
    }

    public Set<String> getTypes() {
        return this.phones.keySet();
    }

    public Phones setByType(String phoneType, String number) {
        this.phones.put(phoneType, StringSupport.trimOrNull((String)number));
        return this;
    }

    @Nullable
    public String getMain() {
        return this.getByType(PHONE_TYPE_MAIN);
    }

    public Phones setMain(String number) {
        this.setByType(PHONE_TYPE_MAIN, number);
        this.main = number;
        return this;
    }

    @Nullable
    public String getMobile() {
        return this.getByType(PHONE_TYPE_MOBILE);
    }

    public Phones setMobile(String number) {
        this.setByType(PHONE_TYPE_MOBILE, number);
        this.mobile = number;
        return this;
    }

    @Nullable
    public String getFax() {
        return this.getByType(PHONE_TYPE_FAX);
    }

    public Phones setFax(String number) {
        this.setByType(PHONE_TYPE_FAX, number);
        this.fax = number;
        return this;
    }

    @Nullable
    public Object getOwner() {
        return this.owner;
    }

    public Phones setOwner(@Nonnull Resource parent) {
        this.owner = parent;
        return this;
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper((Object)this);
        for (String type : SUPPORTED_PHONE_TYPES) {
            helper.add(type, (Object)this.getByType(type));
        }
        if (this.owner != null) {
            helper.add("ownerId", (Object)this.owner.getId());
        }
        return helper.toString();
    }
}

