/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy.property;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.legacy.property.Property;
import com.covisint.platform.legacy.property.PropertyCacheService;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.scheduling.annotation.Scheduled;

public class DefaultPropertyCacheService
extends JdbcDaoSupport
implements PropertyCacheService {
    private static final String DEFAULT_CONTEXT_CODE = "DEF";
    private final Logger log = LoggerFactory.getLogger(DefaultPropertyCacheService.class);
    private final List<String> propertyExpressions;
    private Multimap<String, Property> propertyCache;

    public DefaultPropertyCacheService(@Nonnull @NotEmpty @NonnullElements List<String> expressions, @Nonnull DataSource newDatasource) {
        this.propertyExpressions = Collections.unmodifiableList(Lists.newArrayList((Iterable)Iterables.filter(expressions, (Predicate)Predicates.notNull())));
        this.setDataSource(newDatasource);
        this.reloadCache();
    }

    @Override
    @Scheduled(initialDelayString="${property_cache_timer}", fixedDelayString="${property_cache_timer}")
    public void reloadCache() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        MapSqlParameterSource args = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM PROPERTIES");
        for (int i = 0; i < this.propertyExpressions.size(); ++i) {
            if (i == 0) {
                sqlBuilder.append(" WHERE ");
            } else {
                sqlBuilder.append(" OR ");
            }
            String expr = this.propertyExpressions.get(i);
            String transformed = expr.replaceAll("\\*", "%");
            String comparator = "LIKE";
            if (expr.indexOf(42) == -1) {
                comparator = "=";
            }
            sqlBuilder.append("PROPERTY_NAME ").append(comparator).append(" (:" + i + ")");
            args.addValue(String.valueOf(i), (Object)transformed);
        }
        String sql = sqlBuilder.toString();
        this.log.debug("SQL query used to fetch properties prior to cache: {}", (Object)sql);
        List properties = new NamedParameterJdbcTemplate((JdbcOperations)this.getJdbcTemplate()).query(sql, (SqlParameterSource)args, (RowMapper)new PropertyMapper());
        ImmutableMultimap.Builder cacheBuilder = ImmutableMultimap.builder();
        for (Property property : properties) {
            cacheBuilder.put((Object)property.getPropertyName(), (Object)property);
        }
        this.propertyCache = cacheBuilder.build();
        this.log.info("Loaded property cache in {}.", (Object)stopwatch.stop());
    }

    @Override
    @Nonnull
    @NonnullElements
    public Iterable<Property> getPropertyByName(@Nonnull @NotEmpty String propertyName) {
        return this.propertyCache.get((Object)propertyName);
    }

    @Override
    @Nonnull
    public Optional<Property> getEffectiveProperty(@Nonnull @NotEmpty String propertyName, @Nonnull @NotEmpty String contextCode) {
        Property defaultProperty = null;
        for (Property property : this.getPropertyByName(propertyName)) {
            if (property.getContextCode().equals(contextCode)) {
                return Optional.of((Object)property);
            }
            if (!DEFAULT_CONTEXT_CODE.equalsIgnoreCase(property.getContextCode())) continue;
            defaultProperty = property;
        }
        if (defaultProperty != null) {
            return Optional.of(defaultProperty);
        }
        return Optional.absent();
    }

    private static class PropertyMapper
    implements RowMapper<Property> {
        private PropertyMapper() {
        }

        @Nonnull
        public Property mapRow(ResultSet rs, int rowNum) throws SQLException {
            String name = rs.getString("PROPERTY_NAME");
            String value = rs.getString("PROPERTY_VALUE");
            String context = rs.getString("CONTEXT_CODE");
            String application = rs.getString("APPLICATION_NAME");
            return new Property(name, value, context, application, System.currentTimeMillis());
        }
    }
}

