/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.person;

import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.platform.user.client.person.PersonClientImpl;
import com.covisint.platform.user.core.person.SupportedMediaType;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.google.common.net.MediaType;

public final class PersonClientBuilder
extends BaseResourceClientBuilder<PersonClientBuilder, PersonClientImpl> {
    private static final String PERSON_ID = "personId";
    private static final String RESOURCE_COLLECTION_PATH = "/persons";

    protected String getResourceCollectionPath() {
        return RESOURCE_COLLECTION_PATH;
    }

    protected MediaType getResourceRepresentation() {
        return MediaType.parse((String)SupportedMediaType.PERSON_MT.value());
    }

    public PersonClientImpl build() {
        UriTemplate unsuspendTemplate;
        UriTemplate suspendTemplate;
        UriTemplate activateTemplate;
        PersonClientImpl impl = (PersonClientImpl)this.populateBaseBuilder(new PersonClientImpl());
        try {
            activateTemplate = UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getResourceCollectionPath()).literal("/tasks/activate").query(new String[]{PERSON_ID}).build();
            suspendTemplate = UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getResourceCollectionPath()).literal("/tasks/suspend").query(new String[]{PERSON_ID}).build();
            unsuspendTemplate = UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getResourceCollectionPath()).literal("/tasks/unsuspend").query(new String[]{PERSON_ID}).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new ClientException(e.getMessage());
        }
        impl.setActivateEndpointTemplate(activateTemplate);
        impl.setSuspendEndpointTemplate(suspendTemplate);
        impl.setUnsuspendEndpointTemplate(unsuspendTemplate);
        return impl;
    }
}

