/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.person.account.password;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.user.client.person.account.password.PasswordAccountClient;
import com.covisint.platform.user.core.person.account.password.PasswordAccount;
import com.covisint.platform.user.core.person.account.password.io.json.PasswordAccountJsonConstants;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PasswordAccountClientImpl
extends BaseResourceClient<PasswordAccount>
implements PasswordAccountClient {
    private final Logger log = LoggerFactory.getLogger(PasswordAccountClientImpl.class);
    private UriTemplate passwordAccountUriTemplate;

    void setPasswordAccountUriTemplate(@Nonnull UriTemplate template) {
        this.passwordAccountUriTemplate = template;
    }

    @Override
    public CheckedFuture<PasswordAccount, ServiceException> persist(@Nonnull @NotEmpty String personId, @Nonnull PasswordAccount resource, @Nonnull HttpContext httpContext) {
        try {
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPut(this.passwordAccountUriTemplate.set("id", (Object)personId).expand()), PasswordAccountJsonConstants.PASSWORD_ACCOUNT_V1_MEDIA_TYPE, resource, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<PasswordAccount, ServiceException> get(@Nonnull String id, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-%s", id);
        PasswordAccount cachedResult = (PasswordAccount)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.passwordAccountUriTemplate.set("id", (Object)id).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), PasswordAccountJsonConstants.PASSWORD_ACCOUNT_V1_MEDIA_TYPE, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<PasswordAccount, ServiceException> add(PasswordAccount resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<PasswordAccount, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<PasswordAccount, ServiceException> get(PasswordAccount resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<PasswordAccount>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<PasswordAccount, ServiceException> persist(PasswordAccount resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<PasswordAccount>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        throw new UnsupportedOperationException();
    }
}

