/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.sdk;

import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.user.client.person.account.password.PasswordAccountClientFactory;
import com.covisint.platform.user.client.person.account.password.PasswordAccountClientImpl;
import com.covisint.platform.user.core.person.account.password.PasswordAccount;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.CheckedFuture;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class PasswordAccountSDK
extends PasswordAccountClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public PasswordAccountSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public PasswordAccountSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public PasswordAccountClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public PasswordAccountClient newClient() {
        return new ClientImpl((PasswordAccountClientImpl)super.create());
    }

    private static final class ClientImpl
    implements PasswordAccountClient {
        private final PasswordAccountClientImpl delegate;

        private ClientImpl(@Nonnull PasswordAccountClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<PasswordAccount, ServiceException> getPasswordAccount(@Nonnull @NotEmpty String personId) {
            return this.delegate.get(personId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<PasswordAccount, ServiceException> updatePasswordAccount(@Nonnull @NotEmpty String personId, @Nonnull PasswordAccount account) {
            return this.delegate.persist(personId, account, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface PasswordAccountClient {
        @Nonnull
        public CheckedFuture<PasswordAccount, ServiceException> getPasswordAccount(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<PasswordAccount, ServiceException> updatePasswordAccount(@Nonnull @NotEmpty String var1, @Nonnull PasswordAccount var2);
    }
}

