/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.user.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.user.client.person.request.PersonRequestClientFactory;
import com.covisint.platform.user.client.person.request.PersonRequestClientImpl;
import com.covisint.platform.user.core.person.request.PersonRequest;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class PersonRequestSDK
extends PersonRequestClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public PersonRequestSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public PersonRequestSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public PersonRequestClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public PersonRequestClient newClient() {
        return new ClientImpl((PersonRequestClientImpl)super.create());
    }

    private static final class ClientImpl
    implements PersonRequestClient {
        private final PersonRequestClientImpl delegate;

        private ClientImpl(@Nonnull PersonRequestClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<PersonRequest, ServiceException> get(@Nonnull @NotEmpty String requestId) {
            return this.delegate.get(requestId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<PersonRequest, ServiceException> add(@Nonnull PersonRequest request) {
            return this.delegate.add((Resource)request, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<PersonRequest, ServiceException> delete(@Nonnull @NotEmpty String requestId) {
            return this.delegate.delete(requestId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<PersonRequest>, ServiceException> search(@Nonnull @NotEmpty String registrantId, @Nonnull Page page) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            if (StringSupport.trimOrNull((String)registrantId) != null) {
                searchCriteria.put((Object)"registrant.id", (Object)registrantId);
            }
            return this.delegate.search((Multimap)searchCriteria, SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> approve(@Nonnull @NotEmpty String requestId) {
            return this.delegate.approve(requestId, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface PersonRequestClient {
        @Nonnull
        public CheckedFuture<PersonRequest, ServiceException> get(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<PersonRequest, ServiceException> add(@Nonnull PersonRequest var1);

        @Nonnull
        public CheckedFuture<PersonRequest, ServiceException> delete(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<List<PersonRequest>, ServiceException> search(String var1, @Nonnull Page var2);

        @Nonnull
        public CheckedFuture<Void, ServiceException> approve(@Nonnull @NotEmpty String var1);
    }
}

